function [A] = GetData(iwhich)
rand('seed',0);
randn('seed',0);
switch iwhich
    case 1
        A = GetRealData_w1a;
    case 2
        m = 500;
        n = 1000;
        A = GetTDT2(m,n);
    case 3
        m = 8000;
        n = 1000;
        A = Get20Newsgroups(m,n);
    case 4
        m = 6412;
        n = 1000;
        A = GetSector(m,n);
    case 5
        m = 2000;
        n = 1000;
        A = GetRealDataE2006(m,n);
    case 6
        A = GetDataMnist_uint8;
        
    case 7
        m = 3000;
        n = 1000;
        A = GetGisette(m,n);
    case 8
        m = 3000;
        n = 1000;
        A = GetCnn_4096d_Caltech(m,n);
    case 9
        m = 1000;
        n = 1000;
        A = GetCifar(m,n);
    case 10
        m = 500;
        n = 1000;
        A = randn(m,n);
    case 11
        m = 100;
        n = 300;
        A = randn(m,n);
    case 12
        m = 100;
        n = 100;
        A = randn(m,n);
end

A = full(A);
%A = NormData(A,1);
A = A / norm(A(:),2);
% random permutation
A = RandPerm(A);

function [A] = RandPerm(A)
[m,n] = size(A);
A = A(randperm(m,m),randperm(n,n));



function A = GetTDT2(m,n)
load TDT2
A = fea;
[data_m,data_n] = size(A);
s1 = randperm(data_m,m);
s2 = randperm(data_n,n);
A = A(:,s2);
A = A(s1,:);
A = double(A);
% A = A / norm(A(:),2);

function A = GetSector(m,n)
load sector_train;
A = x;
[data_m,data_n] = size(A);
s1 = randperm(data_m,m);
s2 = randperm(data_n,n);
A = A(:,s2);
A = A(s1,:);
A = double(A);
% A = A / norm(A(:),2);



function A = GetGisette(m,n)
load gisette;
A = x;
[data_m,data_n] = size(A);
s1 = randperm(data_m,m);
s2 = randperm(data_n,n);
A = A(:,s2);
A = A(s1,:);
A = double(A);
% A = A / norm(A(:),2);

function A = GetCifar(m,n)
load cifar;
A = data;
[data_m,data_n] = size(A);
s1 = randperm(data_m,m);
s2 = randperm(data_n,n);
A = A(:,s2);
A = A(s1,:);
A = double(A);
% [A] = center(A);
% [m,n] = size(A);
% for i=1:data_n
% A(:,i) = A(:,i) / norm(A(:,i),2);
% end
% A = A / norm(A(:),2);

function A = GetCnn_4096d_Caltech(m,n)
load cnn_4096d_Caltech;
A = x;
[data_m,data_n] = size(A);
s1 = randperm(data_m,m);
s2 = randperm(data_n,n);
A = A(:,s2);
A = A(s1,:);
A = double(A);
% A = A / norm(A(:),2);

function A = Get20Newsgroups(m,n)
load 20Newsgroups;
A = fea;
[data_m,data_n] = size(A);
s1 = randperm(data_m,m);
s2 = randperm(data_n,n);
A = A(:,s2);
A = A(s1,:);
A = double(A);
rand('seed',1);
A = A + rand(size(A))*1e-5;
% A = A / norm(A(:),2);

function A = GetDataMnist_uint8
load mnist_uint8;
A = double(test_x);
% A = A / 255;
% [data_m,data_n] = size(A);
% [m,n] = size(A);
% s1 = randperm(data_m,2000);
% A = A(s1,:);
% A = A / norm(A(:),2);


function A = GetRealData_w1a
load w1a_train;
A = x;
% [data_m,data_n] = size(A);
% s1 = randperm(data_m,m);
% s2 = randperm(data_n,n);
% A = A(:,s2);
% A = A(s1,:);
A = full(A);
% A = A / norm(A(:),2);

function A = GetRealDataE2006(m,n)
load E2006_5000_10000;
A = x;
[data_m,data_n] = size(A);
s1 = randperm(data_m,m);
s2 = randperm(data_n,n);
A = A(:,s2);
A = A(s1,:);
A = full(A);
% A = A / norm(A(:),2);
randn('seed',1);
A = A + randn(size(A))*1e-5;

function [A] = center(A)
[m,n] = size(A);
e = ones(m,1);
A = A - e*e'*A;








