function [X,fobjs,ts] = RADMM_L0PCA(A,mu,r,X,max_iter,timeLimit,HandleObj)
% min_{X} trace(X'AX) + mu*norm(X,1), X is orth
% min_{X} trace(Y'AY) + mu*norm(X,1), X = Y, Y is orth
% L(X,Y,pi) = trace(Y'AY) + mu*norm(X,1) + <X-Y,Pi> + 0.5 beta ||X-Y||_F^2, s.t. Y is orth
timeIntervel = timeLimit/20;
initt = clock;
last_rec_clock = initt;

ts = []; fobjs = [];
fobj = HandleObj(X);
fobjs = [fobjs;fobj];
ts = [ts;etime(clock,initt)];

    
% normA = abs(laneig((A+A')/2,1));
normA = norm(A);
rho = 1;
Pi = randn(size(X))*0.1;
Y = X + randn(size(X))*0.1;
% eta = 1;
for iter = 1:max_iter
    X = prox_l0(Y-Pi/rho,mu/rho);
    X = max(min(X,100),-100); % This is to avoid unbounded solutions for some extreme cases!
    O = X + Pi/rho;
    L = 2*normA + rho;
    grad = 2*A*Y + rho*(Y-O);
    dtX  = grad - Y*grad'*Y;
    eta = 0.1/rho;
    Delta = - eta*dtX;
    Y = retr(Y,Delta);
        
    Y = OrthProj(Y - grad/L);
    diff = X - Y;
    Pi = Pi + rho * diff;
    if ~mod(iter,30)
        rho = min(1e10,rho * 2);
    end

    
        cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        fobj = HandleObj(X);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
%         fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,fobj,e,beta);
    end
    
    
end

function X = retr(X,Delta)
%  [n,r] = size(X);
%   W = @(xi) (eye(n) - 0.5*X*X')*xi *X' - X*xi'*(eye(n) - 0.5*X*X');
%  X = inv(eye(n) - 0.5*W(Delta))*(eye(n) + 0.5*W(Delta))*X;
% X=myQR(X+Delta,size(X,2));
%  [X] = myQR2(X+Delta);

% X = X+Delta;
% B_power = X'*X;
% [U,Sigma,V] = svd(B_power);
% SIGMA =diag(Sigma);
% X = X*(U*diag(sqrt(1./SIGMA))*V');

% polar retraction
% X = X+Delta;
% [U,Sigma] = eig(X'*X);
% SIGMA =diag(Sigma);
% X = X*(U*diag(sqrt(1./SIGMA))*U');

X = X+Delta;
X = X*(Delta'*Delta + eye(size(Delta,2)))^(-0.5);


function [Q,R] = myQR2(X)
[Q, R] = qr(X,0);

function [Q, RR] = myQR(XX,k)
[Q, RR] = qr(XX, 0);
diagRR = sign(diag(RR)); ndr = diagRR < 0;
if nnz(ndr) > 0
    %     Q = Q*spdiags(diagRR,0,k,k);
    Q(:,ndr) = Q(:,ndr)*(-1);
end
