function [X,fobjs,ts] = ADMM_L0PCA(A,mu,r,X,max_iter,timeLimit,HandleObj)
% min_{X} trace(X'AX) + mu*norm(X,1), X is orth
% min_{X} trace(Y'AY) + mu*norm(X,1), X = Y, Y is orth
% L(X,Y,pi) = trace(Y'AY) + mu*norm(X,1) + <X-Y,Pi> + 0.5 beta ||X-Y||_F^2, s.t. Y is orth

timeIntervel = timeLimit/20;
initt = clock;
last_rec_clock = initt;

ts = []; fobjs = [];
fobj = HandleObj(X);
fobjs = [fobjs;fobj];
ts = [ts;etime(clock,initt)];

% normA = abs(laneig((A+A')/2,1));
normA = norm(A);
rho = 100;
Pi = randn(size(X))*0.01;
Y = X ;

for iter = 1:max_iter
    X = prox_l0(Y-Pi/rho,mu/rho);
    X = max(min(X,100),-100);% This is to avoid unbounded solutions for some extreme cases!
    O = X + Pi/rho;
    L = 2*normA + rho;
    grad = 2*A*Y + rho*(Y-O);
    Y = OrthProj(Y - grad/L);
    diff = X - Y;
    Pi = Pi + rho * diff;
    if ~mod(iter,30)
        rho = min(1e10,rho * 2);
    end
    
    
    cur_clock = clock;
    if(etime(cur_clock,last_rec_clock) > timeIntervel)
        fobj = HandleObj(X);
        ElasTime =  etime(cur_clock,initt);
        fobjs  = [fobjs;fobj];
        ts = [ts;ElasTime];
        last_rec_clock = cur_clock;
        if ElasTime > timeLimit,break; end
%         fprintf('iter:%d, fobj:%f, dist:%f, beta:%f\n',iter,fobj,e,beta);
    end
    

    
end


