
# %%

from distutils.log import Log
import os
import numpy as np
import scipy
import pandas as pd
import time

from sklearn.model_selection import train_test_split
from sklearn.decomposition import PCA
from sklearn.linear_model import LogisticRegression, LogisticRegressionCV, SGDClassifier, \
    RidgeClassifier, RidgeClassifierCV
from sklearn.ensemble import RandomForestClassifier
from sklearn.metrics import accuracy_score, roc_auc_score, balanced_accuracy_score
from sklearn.preprocessing import StandardScaler

import matplotlib.pyplot as plt
import argparse

import tensorflow as tf
from tensorflow import keras

from xgboost import XGBClassifier

np.random.seed(0)

X_train = np.random.randn(100, 10)
y_train = X_train[:, 0] > 0
y_train = y_train * 1
y_train[0:20] = 1
w = y_train * 0.0 + 1.0

# ridge = RidgeClassifierCV(alphas=np.logspace(-3, 2, 50), cv=5)
# ridge.fit(X_train, y_train, sample_weight=w)
# alpha = ridge.alpha_
# print("Alpha: {}".format(alpha))

ridge = RidgeClassifier(alpha=0)
ridge.fit(X_train, y_train, sample_weight=w)
alpha = 0

lr = LogisticRegression(penalty='l2', C=1.0)
lr.fit(X_train, y_train, sample_weight=w)

lr = LogisticRegressionCV(penalty='l2', Cs=50)
lr.fit(X_train, y_train, sample_weight=w)

print(lr.C_)

inputs = keras.Input(shape=(X_train.shape[1],))
outputs = keras.layers.Dense(1, kernel_regularizer=keras.regularizers.l2(l2=1/(2*X_train.shape[0]*lr.C_[0])), activation='sigmoid')(inputs)
model = keras.Model(inputs, outputs)
model.layers[1].set_weights([lr.coef_.reshape([-1, 1]), ridge.intercept_])
optimizer = tf.keras.optimizers.Adam(learning_rate=0.01)
model.compile(optimizer=optimizer, loss=keras.losses.binary_crossentropy, metrics=[keras.metrics.BinaryAccuracy()])
model.fit(X_train, y_train, epochs=100, batch_size=X_train.shape[0], sample_weight=w)



print("Alpha: {}".format(alpha))
print(ridge.coef_)
print(lr.coef_)
print(model.layers[1].get_weights())
