from sklearn.base import BaseEstimator,TransformerMixin

import os
import numpy as np
import scipy
import pandas as pd
import time


class Augmenter(BaseEstimator, TransformerMixin):
    # See https://stackoverflow.com/questions/25539311/custom-transformer-for-sklearn-pipeline-that-alters-both-x-and-y
    def __init__(self, nover2, factor=10):
        self.nover2 = nover2
        self.factor = factor # data augmentation factor

    def fit( self, X, y=None):
        return self 

    def transform( self, X, y=None):
        return X

    def fit_transform(self, X, y):
        print('\n\n\nMADE IT TO FIRST CKPT')
        # print(X.shape)
        # import traceback
        # traceback.print_stack()

        if y is None:
            return X

        X_bal = X.copy()
        y_bal = y.copy()
        for i in range(2, self.factor):
            X_bal = np.concatenate([X_bal, X.copy()], axis=0)
            y_bal = np.concatenate([y_bal, y.copy()])

        # Check that we are operating on the train fold
        if X.shape[0] > self.nover2:
            for val in [0, 1]:
                print('\n\n\n\nI AM HEREEEEEEEE')
                idxs = y == val
                X_temp = X[idxs, :]
                n = X_temp.shape[0]
                n_aug = int(self.factor * n) - n
                lam = np.random.rand(n_aug).reshape([-1, 1])
                idx1 = np.random.choice(n, size=n_aug)
                idx2 = np.random.choice(n, size=n_aug)
                # Take convex combination
                X_aug = lam * X_temp[idx1, :] + (1 - lam) * X_temp[idx2, :]

                X = np.concatenate([X, X_aug], axis=0)
                y = np.concatenate([y, np.repeat(val, n_aug)])
            X = np.concatenate([X, X_bal], axis=0)
            y = np.concatenate([y, y_bal])
            return X, y
        return self.transform(X, y)
