import errno
import os
import sys
import time
import math
import torch.nn as nn
import numpy as np

__all__ = ['AverageMeter', 'RunningMeter']

class RunningMeter(object):
    def __init__(self):
        self.steps = 0
        self.total = 0

    def update(self, val):
        self.total += val
        self.steps += 1

    def update2(self, val, bsz):
        self.total += val
        self.steps += bsz

    def value(self):
        return self.total/float(self.steps)

class AverageMeter(object):
    def __init__(self):
        self.reset()

    def reset(self):
        self.val = 0
        self.avg = 0
        self.sum = 0
        self.count = 0
        self.agg = 0

    def update(self, val, n=1):
        self.val = val
        self.sum += val * n
        self.count += n
        self.avg = self.sum / self.count

    def aggregate(self, val, n_branches, n=1):
        self.val = val
        self.sum += val * n
        self.count += n
        self.agg = self.sum / (self.count * n_branches)
