from .iterative.fgsm import FGSM
from .iterative.ifgsm import IFGSM
from .iterative.mifgsm import MIFGSM
from .iterative.vmifgsm import VMIFGSM
from .iterative.nifgsm import NIFGSM
from .iterative.gimifgsm import GIMIFGSM,GINIFGSM,GIVMIFGSM,GIEMIFGSM,GIPIFGSM
from .iterative.pifgsm import PIFGSM
from .iterative.emifgsm import EMIFGSM
from .bayes.nit import NIT_IFGSM
from .iterative.rgimifgsm import RGIMIFGSM,RGINIFGSM,RGIPIFGSM,RGIVMIFGSM,RGIEMIFGSM
from .iterative.sifgsm import SIFGSM, SMIFGSM, SNIFGSM, SPIFGSM, SEMIFGSM, SVMIFGSM, SGIMIFGSM
from .iterative.spifgsm import ScIFGSM, ScMIFGSM, ScPIFGSM, ScVMIFGSM, ScGIMIFGSM
from .iterative.inv_spifgsm import  InvScIFGSM, InvScMIFGSM, InvScPIFGSM, InvScVMIFGSM, InvScGIMIFGSM
from .iterative.self_ens import ENS_FGSM_SMIFGSM, ENS_IFGSM_SMIFGSM, ENS_MIX_SMIFGSM, ENS_FGSM_SVMIFGSM, ENS_IFGSM_SVMIFGSM, ENS_MIX_SVMIFGSM
from .iterative.self_ens import ENS_FGSM_SIFGSM, ENS_FGSM_SGIMIFGSM, ENS_IFGSM_SGIMIFGSM, ENS_MIX_SGIMIFGSM,ENS_FGSM_SPIFGSM
from .transformation.ssa import SSA,FIA_SSA
from .transformation.ide import IDE
from .transformation.ssa import SSA, l2hSSA, h2lSSA
from .transformation.admix import Admix, spec_Admix
from .transformation.dim import DIM
from .transformation.tim import TIM
from .transformation.dem import DEM
from .transformation.sim import SIM
from .transformation.ssa_based import SSA_alpha
from .ensemble.logitens import AIT, LogitEns, GA_logit
from .ensemble.lossens import LossEns,LossEns_AIT
from .ensemble.predicts import PredictEns, AIT_predict, GA_predict
from .ensemble.seqens import SeqEns, RSeqEns

attack_zoo = {'fgsm': FGSM, 
             'ifgsm': IFGSM,
             'mifgsm': MIFGSM,
             'vmifgsm': VMIFGSM,
             'nifgsm': NIFGSM,
             'pifgsm': PIFGSM,
             'gimifgsm': GIMIFGSM,
             'emifgsm': EMIFGSM,
             'rgimifgsm': RGIMIFGSM,
             'rginifgsm': RGINIFGSM,
             'rgivmifgsm': RGIVMIFGSM,
             'rgiemifgsm': RGIEMIFGSM,
             'rgipifgsm': RGIPIFGSM,
             'ginifgsm': GINIFGSM,
             'givmifgsm': GIVMIFGSM,
             'giemifgsm': GIEMIFGSM,
             'gipifgsm': GIPIFGSM,
             'sifgsm': SIFGSM,
             'smifgsm': SMIFGSM,
             'snifgsm': SNIFGSM,
             'spifgsm': SPIFGSM,
             'semifgsm': SEMIFGSM,
             'svmifgsm': SVMIFGSM,
             'sgimifgsm': SGIMIFGSM,
             'scifgsm': ScIFGSM,
             'scmifgsm': ScMIFGSM, 
             'scpifgsm': ScPIFGSM,
             'scvmifgsm': ScVMIFGSM,
             'scgimifgsm': ScGIMIFGSM,
             'inv_scifgsm': InvScIFGSM,
             'inv_scmifgsm': InvScMIFGSM,
             'inv_scvmifgsm': InvScVMIFGSM,
             'inv_scgimifgsm': InvScGIMIFGSM,
             'inv_scpifgsm': InvScPIFGSM,
             'ens_fgsm_sifgsm': ENS_FGSM_SIFGSM,
             'ens_fgsm_smifgsm': ENS_FGSM_SMIFGSM,
             'ens_ifgsm_smifgsm': ENS_IFGSM_SMIFGSM,
             'ens_mix_smifgsm': ENS_MIX_SMIFGSM,
             'ens_fgsm_svmifgsm': ENS_FGSM_SVMIFGSM,
             'ens_ifgsm_svmifgsm': ENS_IFGSM_SVMIFGSM,
             'ens_mix_svmifgsm': ENS_MIX_SVMIFGSM,
             'ens_fgsm_sgimifgsm': ENS_FGSM_SGIMIFGSM,
             'ens_ifgsm_sgimifgsm': ENS_IFGSM_SGIMIFGSM,
             'ens_mix_sgimifgsm': ENS_MIX_SGIMIFGSM,
             'ens_fgsm_spifgsm': ENS_FGSM_SPIFGSM,
             'ssa'        : SSA,
             'l2hssa'     : l2hSSA,
             'h2lssa'     : h2lSSA,
             'ide'        : IDE,
             'admix'      : Admix,
             'dim'        : DIM,
             'tim'        : TIM,
             'dem'        : DEM,
             'sim'        : SIM,
             'ssa_alpha'  : SSA_alpha,
             'spec_admix' : spec_Admix,
             'fia_ssa'    : FIA_SSA,
             'logit_ait'         : AIT,
             'logit_ens'   : LogitEns,
             'loss_ens'    : LossEns,
             'loss_ait'    : LossEns_AIT,
             'predict_ens' : PredictEns,
             'predict_ait' : AIT_predict,
             'predict_ga'  : GA_predict,
             'logit_ga'    : GA_logit,
             'seq_ens'      : SeqEns,
             'rseq_ens'     : RSeqEns,
        }

__version__ = '2.2.0'