import hydra
from omegaconf import DictConfig, OmegaConf

import importlib

from model import make_model

import wandb

@hydra.main(version_base=None, config_path="config", config_name="config")
def main(config: DictConfig):
    
    model_device, editor_device = "cuda:0", "cuda:0"
    
    wandb.init(
        project = config.data.name,
        name = f"{config.editor.name}_{str(config.data.n_edits)}",
        config = OmegaConf.to_container(config, resolve = True)
    )
     
    data_class = importlib.import_module(f"data.{config.data.name}")
    train_loader, valid_loader = data_class.make_loader(config, model_device)
    
    model = make_model(config.model).to(model_device)

    editor_module = importlib.import_module(f"editor.{config.editor.name}")
    editor_class = getattr(editor_module, config.editor.name.upper())
    editor = editor_class(config, model, editor_device)
    editor.run(train_loader, valid_loader)
    
if __name__ == "__main__":
    main()