# only save 100 classes with most images.
import os
import shutil

class_names = [name for name in os.listdir('clipart')]
class_count = {}

for c in class_names:
    class_count[c] = len([file for file in os.listdir('clipart/'+c)])

for domain in ['quickdraw/', 'infograph/', 'painting/', 'real/', 'sketch/']:
    for c in class_names:
        class_count[c] += len([file for file in os.listdir(domain+c)])

sorted_class_count = {k: v for k, v in sorted(class_count.items(), key=lambda item: item[1])}

i = 0
reduced_class_count = {}
for c in sorted_class_count.keys():
    reduced_class_count[c] = sorted_class_count[c]
    i+=1
    if i == 245:
        break

for domain in ['quickdraw/', 'infograph/', 'painting/', 'real/', 'sketch/', 'clipart/']:
    for c in reduced_class_count.keys():
        shutil.rmtree(domain+c)

