#!/bin/bash

ModelArray=(
    "resnet20" "resnet32" "resnet44"
)
ActivationArray=(
    "relu" "leakyrelu" "prelu" "mish" "silu" "hardsilu" "la_silu" "la_hardsilu"
)
device=0
data=CIFAR10 
data_path='../data/CIFAR10'

echo DataSet : $data
for model in "${ModelArray[@]}"; do
    echo Model : $model
    for activation in "${ActivationArray[@]}"; do
        echo Activation : $activation
        python3 train.py -d $data -m $model -a $activation --data_path $data_path --resume False --duplicate True --end_trial 3 --save False
    done
done