#!/bin/bash

ModelArray=(
    "resnet50" 
)
ActivationArray=(
    "relu" "leakyrelu" "prelu" "mish" "silu" "hardsilu" "la_silu" "la_hardsilu"
)
device=0
data=ImageNet
data_path='../data/ImageNet'

echo DataSet : $data
for model in "${ModelArray[@]}"; do
    echo Model : $model
    for activation in "${ActivationArray[@]}"; do
        echo Activation : $activation
        python3 train_parallel.py -d $data -m $model -a $activation --data_path $data_path --resume False --duplicate True --end_trial 3 --save True
    done
done