import torch
from utils import load_model
from benchmark import *

if torch.cuda.is_available():
    DEVICE = 'cuda'
else:
    DEVICE = 'cpu'

model_name = 'llama'
size = 7
LAYERS = 32
CREATE_NEW = True

def main():
    if DEVICE == 'cuda' and 'model' not in locals() and CREATE_NEW:
        model, tokenizer = load_model(model_name=model_name, size=size, device=DEVICE, quantize=False)
    elif 'model' not in locals():
        tokenizer = load_model(model_name=model_name, size=size, device='cpu', quantize=False)

    if CREATE_NEW:
        for category in CATEGORIES:
            create_data(category, model, tokenizer, DEVICE, LAYERS)

    # analyses
    top_k(k=10, LAYERS=LAYERS, tokenizer=tokenizer)
    top_k_all(k=10, LAYERS=LAYERS, tokenizer=tokenizer)
    regression(LAYERS=LAYERS, tokenizer=tokenizer)

if __name__ == '__main__':
    main()