## Explaining the Uncertain: Stochastic Shapley Values for Gaussian Process Models

Code base for the project: "Explaining the Uncertain: Stochastic Shapley Values for Gaussian Process Models"

---
#### Illustration 1: Ablation study
To run an ablation study on different uncertainties captured by GP-SHAP, BayesSHAP, and BayesGP-
SHAP when computing local explanations (SSVs) using the California housing dataset, see
```notebooks/explaining_housing_data_ablation.ipynb```

#### Illustration 2: Exploratory analysis of the stochastic explanations
To illustrate possible exploratory analyses utilising the BayesGP-SHAP covariance
structure, applied on the breast cancer dataset, see
```notebooks/explaining_breast_cancer_Data_with_exploratory_tool.ipynb```

#### Illustration 3: Predictive explanations
To run the predictive explanation experiment,
```commandline
python src/experiments/predictive_shapley_values/main.py
```

#### Further illustrations
1. Explaining diabetic dataset
```notebooks/explaining_diabetic_data.ipynb```
2. Explaining the UCI elevator dataset
```notebooks/Explanation_experiment_UCI_elevator.ipynb```