source $CONDA_SH

###
# LLM Inference

conda env create -f src/llm/environments/inference_environment.yml
conda activate llm-inference

# huggingface
pip install torch==2.4 torchvision torchaudio --index-url https://download.pytorch.org/whl/cu124
pip install transformers==4.47.1

MAX_JOBS=4 pip install flash-attn==2.7.2.post1 --no-build-isolation

# accelerate inference
pip install vllm==0.8.2

conda deactivate

###
# LLM Training
conda env create -f src/llm/environments/training_environment.yml
conda activate llm-training

# huggingface
pip install torch==2.4 torchvision torchaudio --index-url https://download.pytorch.org/whl/cu124
# 4.48.0.dev0
pip install git+https://github.com/huggingface/transformers.git

pip install accelerate==1.2.1

MAX_JOBS=4 pip install flash-attn==2.7.2.post1 --no-build-isolation

# llama recipes
pip install llama_recipes==0.0.4.post1

# accelerate training
pip install deepspeed==0.16.2
conda install -c conda-forge mpi4py mpich -y

conda deactivate
