#!/bin/bash

export CARLA_ROOT=/home/**/carla_garage/carla
export PYTHONPATH=$PYTHONPATH:${CARLA_ROOT}/PythonAPI
export PYTHONPATH=$PYTHONPATH:${CARLA_ROOT}/PythonAPI/carla
export PYTHONPATH=$PYTHONPATH:${CARLA_ROOT}/PythonAPI/carla/dist/carla-0.9.14-py3.7-linux-x86_64.egg
export PYTHONPATH="${CARLA_ROOT}/PythonAPI/carla/":${PYTHONPATH}
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:~/.conda/envs/garage_2/lib

export OMP_NUM_THREADS=8  # Limits pytorch to spawn at most num cpus cores threads
export OPENBLAS_NUM_THREADS=1  # Shuts off numpy multithreading, to avoid threads spawning other threads.
#torchrun --nnodes=1 --nproc_per_node=1 --max_restarts=1 --rdzv_id=42353467 --rdzv_backend=c10d train.py --id train_id_000 --batch_size 8 --setting all --root_dir ~/code/leaderboard2_human_data/database/training_v0_2023_11_23 --logdir ~/code/leaderboard2_human_data/training_runs/debug --use_controller_input_prediction 1 --use_wp_gru 1 --use_discrete_command 1 --use_tp 1 --continue_epoch 1 --cpu_cores 8 --num_repetitions 1
torchrun --nnodes=1 --nproc_per_node=8 --max_restarts=1 --rdzv_id=$SLURM_JOB_ID --rdzv_backend=c10d \
    train.py --setting 12_only \
    --root_dir /mnt/**/datasets/carla \
    --logdir /home/**/GaussianFusion/logs \
    --use_controller_input_prediction 0 --cpu_cores 32 \

# /home/geiger/gwb791/code/leaderboard2_human_data/database/training_v3_oldtowns_2024_04_10
#--root_dir /home/geiger/gwb791/code/leaderboard2_human_data/database/training_v3_oldtowns_2024_04_10 /mnt/qb/work/geiger/gwb438/leaderboard2_human_data/database/expert_v3_dataset_2024_04_10 \ 
