# Motion Post Processing

The motion retarget implementation is adapted from the [Mink](https://github.com/kevinzakka/mink) retarget pipline in the [MaskedMimic](https://github.com/NVlabs/ProtoMotions) codebase.

## Install

```
conda create -n post_processing python=3.8
conda activate post_processing
pip install -r requirements.txt
```

Download the [SMPL](https://smpl.is.tue.mpg.de/) v1.1.0 parameters and place them in the data/smpl/ folder. Rename the files basicmodel_neutral_lbs_10_207_0_v1.1.0, basicmodel_m_lbs_10_207_0_v1.1.0.pkl, basicmodel_f_lbs_10_207_0_v1.1.0.pkl to SMPL_NEUTRAL.pkl, SMPL_MALE.pkl and SMPL_FEMALE.pkl.

The STL files are in `/PBHC/code/policy/humanoidverse/data/robots/g1/meshes`. Copy these STL files to `./data/assets/meshes/`.

## Count Contact Mask

```
python count_contact_mask_smpl.py --folder <path_to_motions> --correction False
```
- If using motion correction, set `--correction True`


## Motion Retarget

```
python data/scripts/convert_fit_motion.py <path_to_motions>
```