from smplx import SMPL
import torch

model = SMPL(model_path='SMPL_NEUTRAL.pkl', gender='neutral')

pose = torch.zeros(1, 72)
beta = torch.zeros(1, 10)
trans = torch.zeros(1, 3) 

output = model.forward(betas=beta, body_pose=pose[:, 3:], global_orient=pose[:, :3], transl=trans)

vertices = output.vertices

joints = output.joints

print("Vertices shape:", vertices.shape)
print("Joints shape:", joints.shape)
print("T-pose joint positions:", joints)


