#!/bin/bash
#SBATCH --nodes=1
#SBATCH --ntasks=1
#SBATCH --gpus=1
#SBATCH --cpus-per-task=18
#SBATCH -t 2-0
#SBATCH --output=outputs/logs/bigbuckbunny_siren
#SBATCH --open-mode=append
#SBATCH --partition=gpu


module load 2022
module load Anaconda3/2022.05
# module load CUDA/11.3.1

source $HOME/.bashrc
mamba activate neomlp

echo "=================================="
echo "Date: $(date)"
echo "Directory: $(pwd)"
python -c 'import torch; print(torch.randn(1).cuda())'

EXTRA_ARGS=$@
echo "Extra args: $EXTRA_ARGS"
# cd experiments/high_res_inr
echo `ls`
srun python -u main.py model=siren data=bigbuckbunny \
  model.hidden_features=1024 data.batch_size=262144 data.eval_batch_size=262144 \
  optim.lr=1e-4 $EXTRA_ARGS

