/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.DiscreteProbs;
import edu.cmu.tetrad.bayes.Proposition;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public final class DataSetProbs
implements DiscreteProbs {
    static final long serialVersionUID = 23L;
    private DataSet dataSet;
    private final int[] dims;
    private boolean boundsEnforced = true;
    private final int numRows;
    private boolean missingValueCaseFound;

    public DataSetProbs(DataSet dataSet) {
        if (dataSet == null) {
            throw new NullPointerException();
        }
        this.dataSet = dataSet;
        this.dims = new int[dataSet.getNumColumns()];
        for (int i = 0; i < this.dims.length; ++i) {
            DiscreteVariable variable = (DiscreteVariable)dataSet.getVariable(i);
            this.dims[i] = variable.getNumCategories();
        }
        this.numRows = dataSet.getNumRows();
    }

    @Override
    public double getCellProb(int[] variableValues) {
        int[] point = new int[this.dims.length];
        int count = 0;
        this.missingValueCaseFound = false;
        block0: for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.dims.length; ++j) {
                point[j] = this.dataSet.getInt(i, j);
                if (point[j] != -99) continue;
                this.missingValueCaseFound = true;
                continue block0;
            }
            if (!Arrays.equals(point, variableValues)) continue;
            ++count;
        }
        return (double)count / (double)this.numRows;
    }

    @Override
    public double getProb(Proposition assertion) {
        int[] point = new int[this.dims.length];
        int count = 0;
        this.missingValueCaseFound = false;
        block0: for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.dims.length; ++j) {
                point[j] = this.dataSet.getInt(i, j);
                if (point[j] != -99) continue;
                this.missingValueCaseFound = true;
                continue block0;
            }
            if (!assertion.isPermissibleCombination(point)) continue;
            ++count;
        }
        return (double)count / (double)this.numRows;
    }

    @Override
    public double getConditionalProb(Proposition assertion, Proposition condition) {
        List<Node> dataVars;
        if (assertion.getVariableSource() != condition.getVariableSource()) {
            throw new IllegalArgumentException("Assertion and condition must be for the same Bayes IM.");
        }
        List<Node> assertionVars = assertion.getVariableSource().getVariables();
        if (!new HashSet<Node>(assertionVars).equals(new HashSet<Node>(dataVars = this.dataSet.getVariables()))) {
            throw new IllegalArgumentException("Assertion variable and data variables are either different or in a different order: \n\tAssertion vars: " + assertionVars + "\n\tData vars: " + dataVars);
        }
        int[] point = new int[this.dims.length];
        int count1 = 0;
        int count2 = 0;
        this.missingValueCaseFound = false;
        block0: for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.dims.length; ++j) {
                point[j] = this.dataSet.getInt(i, j);
                if (point[j] == -99) continue block0;
            }
            if (!condition.isPermissibleCombination(point)) continue;
            ++count1;
            if (!assertion.isPermissibleCombination(point)) continue;
            ++count2;
        }
        return (double)count2 / (double)count1;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    @Override
    public List<Node> getVariables() {
        return null;
    }

    public boolean isBoundsEnforced() {
        return this.boundsEnforced;
    }

    public void setBoundsEnforced(boolean boundsEnforced) {
        this.boundsEnforced = boundsEnforced;
    }

    @Override
    public boolean isMissingValueCaseFound() {
        return this.missingValueCaseFound;
    }
}

