/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.DataFilter;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import java.util.LinkedList;
import java.util.List;

public final class ExtraCategoryInterpolator
implements DataFilter {
    @Override
    public final DataSet filter(DataSet dataSet) {
        if (!dataSet.isDiscrete()) {
            throw new IllegalArgumentException("Data set must be discrete.");
        }
        LinkedList<Node> variables = new LinkedList<Node>();
        for (int i = 0; i < dataSet.getNumColumns(); ++i) {
            DiscreteVariable variable = (DiscreteVariable)dataSet.getVariable(i);
            String oldName = variable.getName();
            List<String> oldCategories = variable.getCategories();
            LinkedList<String> newCategories = new LinkedList<String>(oldCategories);
            String newCategory = "Missing";
            boolean j = false;
            while (oldCategories.contains(newCategory)) {
                newCategory = "Missing" + ++i;
            }
            newCategories.add(newCategory);
            String newName = oldName + "+";
            DiscreteVariable newVariable = new DiscreteVariable(newName, newCategories);
            variables.add(newVariable);
        }
        ColtDataSet newDataSet = new ColtDataSet(dataSet.getNumRows(), variables);
        for (int i = 0; i < dataSet.getNumRows(); ++i) {
            for (int j = 0; j < dataSet.getNumColumns(); ++j) {
                DiscreteVariable variable = (DiscreteVariable)dataSet.getVariable(j);
                int numCategories = variable.getNumCategories();
                int value = dataSet.getInt(i, j);
                if (value == -99) {
                    newDataSet.setInt(i, j, numCategories);
                    continue;
                }
                newDataSet.setInt(i, j, value);
            }
        }
        return newDataSet;
    }
}

