/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataFilter;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import java.util.LinkedList;

public final class MeanInterpolator
implements DataFilter {
    @Override
    public DataSet filter(DataSet dataSet) {
        LinkedList<Node> variables = new LinkedList<Node>();
        for (int i = 0; i < dataSet.getNumColumns(); ++i) {
            Node variable = dataSet.getVariable(i);
            variables.add(variable);
        }
        ColtDataSet newDataSet = new ColtDataSet((ColtDataSet)dataSet);
        for (int j = 0; j < newDataSet.getNumColumns(); ++j) {
            if (!(newDataSet.getVariable(j) instanceof ContinuousVariable)) continue;
            double sum = 0.0;
            int count = 0;
            for (int i = 0; i < newDataSet.getNumRows(); ++i) {
                if (Double.isNaN(newDataSet.getDouble(i, j))) continue;
                sum += newDataSet.getDouble(i, j);
                ++count;
            }
            double mean = sum / (double)count;
            for (int i = 0; i < newDataSet.getNumRows(); ++i) {
                if (!Double.isNaN(newDataSet.getDouble(i, j))) continue;
                newDataSet.setDouble(i, j, mean);
            }
        }
        return newDataSet;
    }
}

