/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.BdeMetric;
import edu.cmu.tetrad.bayes.ModelGenerator;
import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import java.io.File;
import java.io.IOException;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestBDeMetric
extends TestCase {
    public TestBDeMetric(String name) {
        super(name);
    }

    public static void testMetric() {
        String fileName = "test_data/testbdemetricshort.dat";
        File file = new File(fileName);
        try {
            DataReader reader = new DataReader();
            DataSet ds = reader.parseTabular(file);
            GraphNode x1 = new GraphNode("X1");
            GraphNode x2 = new GraphNode("X2");
            GraphNode x3 = new GraphNode("X3");
            GraphNode x4 = new GraphNode("X4");
            GraphNode x5 = new GraphNode("X5");
            Dag graph = new Dag();
            graph.clear();
            graph.addNode(x1);
            graph.addNode(x2);
            graph.addNode(x3);
            graph.addNode(x4);
            graph.addNode(x5);
            graph.addDirectedEdge(x1, x2);
            graph.addDirectedEdge(x2, x3);
            graph.addDirectedEdge(x3, x4);
            BayesPm bayesPm = new BayesPm(graph);
            bayesPm.setNumCategories(x1, 2);
            bayesPm.setNumCategories(x2, 2);
            bayesPm.setNumCategories(x3, 2);
            bayesPm.setNumCategories(x4, 2);
            bayesPm.setNumCategories(x5, 2);
            BdeMetric bdem = new BdeMetric(ds, bayesPm);
            double scoreOrig = bdem.score();
            System.out.println("Score of generating PM = " + scoreOrig);
            List<Graph> variants1 = ModelGenerator.generate(graph);
            for (Graph aVariants1 : variants1) {
                Dag d = new Dag(aVariants1);
                BayesPm bpm = new BayesPm(d);
                BdeMetric bdemr = new BdeMetric(ds, bpm);
                double scorer = bdemr.score();
                System.out.println("Score for above graph = " + scorer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Test suite() {
        return new TestSuite(TestBDeMetric.class);
    }
}

