/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.BayesXmlParser;
import edu.cmu.tetrad.bayes.BayesXmlRenderer;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.NodeType;
import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;
import nu.xom.Serializer;

public final class TestBayesXml
extends TestCase {
    public TestBayesXml(String name) {
        super(name);
    }

    public static void testRoundtrip() {
        BayesIm bayesIm = TestBayesXml.sampleBayesIm1();
        Element element = BayesXmlRenderer.getElement(bayesIm);
        System.out.println("Started with this bayesIm: " + bayesIm);
        System.out.println("\nGot this XML for it:");
        TestBayesXml.printElement(element);
        BayesXmlParser parser = new BayesXmlParser();
        BayesIm bayesIm2 = parser.getBayesIm(element);
        System.out.println(bayesIm2.getDag());
        System.out.println(bayesIm2);
    }

    public void testRoundtrip2() {
        BayesIm bayesIm = TestBayesXml.sampleBayesIm2();
        Element element = BayesXmlRenderer.getElement(bayesIm);
        System.out.println("Started with this bayesIm: " + bayesIm);
        System.out.println("\nGot this XML for it:");
        TestBayesXml.printElement(element);
        BayesXmlParser parser = new BayesXmlParser();
        BayesIm bayesIm2 = parser.getBayesIm(element);
        System.out.println(bayesIm2.getDag());
        System.out.println(bayesIm2);
    }

    public void testRoundtrip3() {
        BayesIm bayesIm = TestBayesXml.sampleBayesIm3();
        Element element = BayesXmlRenderer.getElement(bayesIm);
        System.out.println("Started with this bayesIm: " + bayesIm);
        System.out.println("\nGot this XML for it:");
        TestBayesXml.printElement(element);
        BayesXmlParser parser = new BayesXmlParser();
        BayesIm bayesIm2 = parser.getBayesIm(element);
        System.out.println(bayesIm2.getDag());
        System.out.println(bayesIm2);
    }

    public void testLoadFromFile() {
        try {
            Builder builder = new Builder();
            Document document = builder.build(new File("sample_data/parsableBayesNet.xml"));
            TestBayesXml.printDocument(document);
            BayesXmlParser parser = new BayesXmlParser();
            BayesIm bayesIm = parser.getBayesIm(document.getRootElement());
            System.out.println(bayesIm);
        }
        catch (ParsingException e) {
            e.printStackTrace();
            TestBayesXml.fail("The file referred to cannot be parsed as a Bayes IM. The file referred to MUST LOAD!! PLEASE FIX IMMEDIATELY!!! (Ask Joe Ramsey jdramsey@andrew.cmu.edu for details.");
        }
        catch (IOException e) {
            e.printStackTrace();
            TestBayesXml.fail("The file referred to cannot be opened (or doesn't exist). Maybe the working directory is not set correctly.");
        }
    }

    private static BayesIm sampleBayesIm1() {
        GraphNode a = new GraphNode("a");
        GraphNode b = new GraphNode("b");
        GraphNode c = new GraphNode("c");
        Dag graph = new Dag();
        graph.addNode(a);
        graph.addNode(b);
        graph.addNode(c);
        graph.addDirectedEdge(a, b);
        graph.addDirectedEdge(a, c);
        graph.addDirectedEdge(b, c);
        BayesPm bayesPm = new BayesPm(graph);
        bayesPm.setNumCategories(b, 3);
        MlBayesIm bayesIm1 = new MlBayesIm(bayesPm);
        bayesIm1.setProbability(0, 0, 0, 0.3);
        bayesIm1.setProbability(0, 0, 1, 0.7);
        bayesIm1.setProbability(1, 0, 0, 0.3);
        bayesIm1.setProbability(1, 0, 1, 0.4);
        bayesIm1.setProbability(1, 0, 2, 0.3);
        bayesIm1.setProbability(1, 1, 0, 0.6);
        bayesIm1.setProbability(1, 1, 1, 0.1);
        bayesIm1.setProbability(1, 1, 2, 0.3);
        bayesIm1.setProbability(2, 0, 0, 0.9);
        bayesIm1.setProbability(2, 0, 1, 0.1);
        bayesIm1.setProbability(2, 1, 0, 0.1);
        bayesIm1.setProbability(2, 1, 1, 0.9);
        bayesIm1.setProbability(2, 2, 0, 0.5);
        bayesIm1.setProbability(2, 2, 1, 0.5);
        bayesIm1.setProbability(2, 3, 0, 0.2);
        bayesIm1.setProbability(2, 3, 1, 0.8);
        bayesIm1.setProbability(2, 4, 0, 0.6);
        bayesIm1.setProbability(2, 4, 1, 0.4);
        bayesIm1.setProbability(2, 5, 0, 0.7);
        bayesIm1.setProbability(2, 5, 1, 0.3);
        return bayesIm1;
    }

    private static BayesIm sampleBayesIm2() {
        GraphNode a = new GraphNode("a");
        GraphNode b = new GraphNode("b");
        GraphNode c = new GraphNode("c");
        Dag graph = new Dag();
        graph.addNode(a);
        graph.addNode(b);
        graph.addNode(c);
        graph.addDirectedEdge(a, b);
        graph.addDirectedEdge(a, c);
        graph.addDirectedEdge(b, c);
        BayesPm bayesPm = new BayesPm(graph);
        bayesPm.setNumCategories(b, 3);
        return new MlBayesIm(bayesPm, 1);
    }

    private static BayesIm sampleBayesIm3() {
        GraphNode a = new GraphNode("a");
        a.setNodeType(NodeType.LATENT);
        a.setCenterX(5);
        a.setCenterY(5);
        GraphNode b = new GraphNode("b");
        GraphNode c = new GraphNode("c");
        Dag graph = new Dag();
        graph.addNode(a);
        graph.addNode(b);
        graph.addNode(c);
        graph.addDirectedEdge(a, b);
        graph.addDirectedEdge(a, c);
        graph.addDirectedEdge(b, c);
        BayesPm bayesPm = new BayesPm(graph);
        bayesPm.setNumCategories(b, 3);
        return new MlBayesIm(bayesPm, 1);
    }

    private static void printElement(Element element) {
        TestBayesXml.printDocument(new Document(element));
    }

    private static void printDocument(Document document) {
        Serializer serializer = new Serializer(System.out);
        serializer.setLineSeparator("\n");
        serializer.setIndent(2);
        try {
            serializer.write(document);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Test suite() {
        return new TestSuite(TestBayesXml.class);
    }
}

