/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.bayes.StoredCellProbs;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConverter;
import edu.cmu.tetrad.graph.Node;
import java.util.LinkedList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestCellProbabilities
extends TestCase {
    public TestCellProbabilities(String name) {
        super(name);
    }

    public static void testCreateRandom() {
        DiscreteVariable x = new DiscreteVariable("X", 3);
        DiscreteVariable y = new DiscreteVariable("Y", 3);
        DiscreteVariable z = new DiscreteVariable("Z", 3);
        DiscreteVariable w = new DiscreteVariable("W", 2);
        LinkedList<Node> variables = new LinkedList<Node>();
        variables.add(x);
        variables.add(y);
        variables.add(z);
        variables.add(w);
        StoredCellProbs cellProbabilities = StoredCellProbs.createRandomCellTable(variables);
        System.out.println(cellProbabilities);
    }

    public static void testCreateUsingBayesIm() {
        Graph graph = GraphConverter.convert("X1-->X2,X1-->X3,X2-->X4,X3-->X4");
        Dag dag = new Dag(graph);
        BayesPm bayesPm = new BayesPm(dag);
        MlBayesIm bayesIm = new MlBayesIm(bayesPm, 1);
        StoredCellProbs cellProbs = StoredCellProbs.createCellTable(bayesIm);
        System.out.println(cellProbs);
    }

    public static Test suite() {
        return new TestSuite(TestCellProbabilities.class);
    }
}

