/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.bayes;

import edu.cmu.tetrad.bayes.BayesImProbs;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.CellTableProbs;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConverter;
import edu.cmu.tetrad.util.RandomUtil;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestDataSetCellProbs
extends TestCase {
    public TestDataSetCellProbs(String name) {
        super(name);
    }

    public static void testCreateUsingBayesIm() {
        Graph graph = GraphConverter.convert("X1-->X2,X1-->X3,X2-->X4,X3-->X4");
        Dag dag = new Dag(graph);
        BayesPm bayesPm = new BayesPm(dag);
        MlBayesIm bayesIm = new MlBayesIm(bayesPm, 1);
        BayesImProbs bayesImProbs = new BayesImProbs(bayesIm);
        DataSet dataSet = bayesIm.simulateData(1000, false);
        CellTableProbs dataSetProbs = new CellTableProbs(dataSet);
        int[] cell = new int[4];
        for (int i = 0; i < 200; ++i) {
            for (int j = 0; j < 4; ++j) {
                cell[j] = RandomUtil.getInstance().nextInt(bayesIm.getNumColumns(j));
            }
            double count1 = bayesImProbs.getCellProb(cell);
            double count2 = dataSetProbs.getCellProb(cell);
            TestDataSetCellProbs.assertEquals(count1, count2, 0.05);
        }
    }

    public static Test suite() {
        return new TestSuite(TestDataSetCellProbs.class);
    }
}

