/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.cluster;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.jet.math.PlusMult;
import edu.cmu.tetrad.cluster.ClusteringAlgorithm;
import edu.cmu.tetrad.cluster.metrics.Dissimilarity;
import edu.cmu.tetrad.cluster.metrics.SquaredErrorLoss;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Ap
implements ClusteringAlgorithm {
    DoubleMatrix2D data;
    private boolean verbose = false;
    private double lambda = 0.0;
    private Dissimilarity metric = new SquaredErrorLoss();

    @Override
    public void cluster(DoubleMatrix2D data) {
        this.data = data;
        int n = data.rows();
        int m = data.columns();
        DenseDoubleMatrix2D s = new DenseDoubleMatrix2D(n, n);
        for (int i = 0; i < n; ++i) {
            for (int k = 0; k < n; ++k) {
                s.set(i, k, -this.metric.dissimilarity(data.viewRow(i), data.viewRow(k)));
            }
        }
        ArrayList<Double> offDiagonals = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            for (int k = 0; k < n; ++k) {
                if (i == k) continue;
                offDiagonals.add(s.get(i, k));
            }
        }
        Collections.sort(offDiagonals);
        int size = offDiagonals.size();
        Double m1 = (Double)offDiagonals.get(size / 2 - 1);
        Double m2 = (Double)offDiagonals.get(size - size / 2);
        double median = (m1 + m2) / 2.0;
        for (int i = 0; i < n; ++i) {
            s.set(i, i, median);
        }
        DenseDoubleMatrix2D r = new DenseDoubleMatrix2D(n, n);
        DoubleMatrix2D rOld = r.like();
        DenseDoubleMatrix2D a = new DenseDoubleMatrix2D(n, n);
        DoubleMatrix2D aOld = a.like();
        for (int repetition = 0; repetition < 100; ++repetition) {
            int k;
            int i;
            System.out.println("Repetition " + repetition);
            rOld.assign(r);
            for (i = 0; i < n; ++i) {
                for (k = 0; k < n; ++k) {
                    double max = Double.NEGATIVE_INFINITY;
                    for (int kk = 0; kk < n; ++kk) {
                        double mmax;
                        if (kk == k || !((mmax = a.get(i, kk) + s.get(i, kk)) > max)) continue;
                        max = mmax;
                    }
                    r.set(i, k, s.get(i, k) - max);
                }
            }
            ((DoubleMatrix2D)r).assign(rOld, new DoubleDoubleFunction(){

                @Override
                public double apply(double v, double v1) {
                    return (1.0 - Ap.this.lambda) * v + Ap.this.lambda * v1;
                }
            });
            aOld.assign(a);
            for (i = 0; i < n; ++i) {
                for (k = 0; k < n; ++k) {
                    double sum = r.get(k, k);
                    for (int ii = 0; ii < n; ++ii) {
                        if (ii == i || ii == k) continue;
                        sum += Math.max(0.0, r.get(ii, k));
                    }
                    if (i == k) {
                        a.set(i, k, sum);
                        continue;
                    }
                    a.set(i, k, Math.min(0.0, sum));
                }
            }
            ((DoubleMatrix2D)a).assign(aOld, new DoubleDoubleFunction(){

                @Override
                public double apply(double v, double v1) {
                    return (1.0 - Ap.this.lambda) * v + Ap.this.lambda * v1;
                }
            });
        }
        DoubleMatrix2D e = r.copy();
        e.assign(a, PlusMult.plusMult(1.0));
        ArrayList<Integer> exemplars = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            if (!(r.get(i, i) > 0.0)) continue;
            exemplars.add(i);
        }
        System.out.println(exemplars);
    }

    @Override
    public List<List<Integer>> getClusters() {
        return new ArrayList<List<Integer>>();
    }

    @Override
    public DoubleMatrix2D getPrototypes() {
        return null;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

