/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.cluster;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Mult;
import cern.jet.math.PlusMult;
import edu.cmu.tetrad.cluster.ClusteringAlgorithm;
import edu.cmu.tetrad.cluster.KMeans;
import edu.cmu.tetrad.util.ProbUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Cats
implements ClusteringAlgorithm {
    private static double SQRT2 = Math.sqrt(2.0);
    private DoubleMatrix2D Y;
    private boolean fdrScreeningDone = false;
    private boolean confidenceBallScreeningDone = false;
    private boolean verbose = true;
    private boolean fHatCalculated = false;
    private List<List<Integer>> clusters;
    private ClusteringAlgorithm clusteringAlgorithm;
    private DoubleMatrix2D thetaTilde;
    private DoubleMatrix2D fHat;

    public Cats() {
        this.setClusteringAlgorithm(KMeans.randomPoints(15));
    }

    @Override
    public void cluster(DoubleMatrix2D data) {
        this.Y = data;
        int n = this.Y.rows();
        int m = this.Y.columns();
        DoubleMatrix2D thetaTilde = this.calculateTransformedData(m, n);
        System.out.println("Starting K Means");
        ClusteringAlgorithm algorithm = this.getClusteringAlgorithm();
        algorithm.setVerbose(this.isVerbose());
        algorithm.cluster(thetaTilde);
        this.clusters = algorithm.getClusters();
    }

    public boolean isFdrScreeningDone() {
        return this.fdrScreeningDone;
    }

    public void setFdrScreeningDone(boolean fdrScreeningDone) {
        this.fdrScreeningDone = fdrScreeningDone;
    }

    public boolean isConfidenceBallScreeningDone() {
        return this.confidenceBallScreeningDone;
    }

    public void setConfidenceBallScreeningDone(boolean confidenceBallScreeningDone) {
        this.confidenceBallScreeningDone = confidenceBallScreeningDone;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
        if (this.clusteringAlgorithm != null) {
            this.clusteringAlgorithm.setVerbose(this.isVerbose());
        }
    }

    public boolean isFHatCalculated() {
        return this.fHatCalculated;
    }

    public void setFHatCalculated(boolean fHatCalculated) {
        this.fHatCalculated = fHatCalculated;
    }

    public DoubleMatrix2D getFHat() {
        return this.fHat;
    }

    public ClusteringAlgorithm getClusteringAlgorithm() {
        return this.clusteringAlgorithm;
    }

    public void setClusteringAlgorithm(ClusteringAlgorithm clusteringAlgorithm) {
        this.clusteringAlgorithm = clusteringAlgorithm;
        this.clusteringAlgorithm.setVerbose(this.isVerbose());
    }

    public DoubleMatrix2D getThetaTilde() {
        return this.thetaTilde;
    }

    @Override
    public List<List<Integer>> getClusters() {
        return this.clusters;
    }

    @Override
    public DoubleMatrix2D getPrototypes() {
        return null;
    }

    public DoubleMatrix2D calculateTransformedData(int m, int n) {
        this.thetaTilde = null;
        DoubleMatrix2D phi = this.calculatePhi(m, m);
        phi = this.grahamSchmidt(phi);
        DoubleMatrix2D thetaHat = this.calculateThetaHat(this.Y, phi);
        DoubleMatrix1D sigmaHatSquared = this.calculateSigmaHatSquared(thetaHat);
        DoubleMatrix2D RHat = this.calculateRHat(sigmaHatSquared, thetaHat);
        DoubleMatrix2D rHat = this.calculateLittleRHat(RHat);
        DoubleMatrix1D t = this.calculateT(rHat);
        int JHat = this.calculateJHat(m, t);
        if (this.isFHatCalculated()) {
            this.calculateFHat(n, m, JHat, phi);
        }
        if (this.isFdrScreeningDone()) {
            this.screenFlatCurvesFdr(n, m, thetaHat);
        }
        if (this.isConfidenceBallScreeningDone()) {
            this.screenFlatCurvesConfidenceBalls(n, sigmaHatSquared, m, JHat, thetaHat);
        }
        this.thetaTilde = this.calculateThetaTilde(thetaHat, n, JHat);
        return this.getThetaTilde();
    }

    private DoubleMatrix2D calculatePhi(int m, int kMax) {
        if (this.isVerbose()) {
            System.out.println("Calculating phi.");
        }
        DenseDoubleMatrix2D phi = new DenseDoubleMatrix2D(m, kMax);
        for (int i = 0; i < m; ++i) {
            if (this.isVerbose() && (i + 1) % 1000 == 0) {
                System.out.println(i + 1);
            }
            for (int j = 0; j < m; ++j) {
                if (j == 0) {
                    phi.set(i, j, 1.0);
                    continue;
                }
                phi.set(i, j, this.phi(j, this.t(i, m)));
            }
        }
        return phi;
    }

    private DoubleMatrix2D grahamSchmidt(DoubleMatrix2D thetaHat) {
        Algebra a = new Algebra();
        DenseDoubleMatrix2D u = new DenseDoubleMatrix2D(thetaHat.rows(), thetaHat.columns());
        u.viewColumn(0).assign(thetaHat.viewColumn(0));
        u.viewColumn(0).assign(Mult.div(this.length(u.viewColumn(0))));
        for (int j1 = 1; j1 < thetaHat.columns(); ++j1) {
            u.viewColumn(j1).assign(thetaHat.viewColumn(j1));
            for (int j2 = 0; j2 < j1 - 1; ++j2) {
                double v1 = a.mult(u.viewColumn(j2), thetaHat.viewColumn(j1));
                double v2 = a.mult(u.viewColumn(j2), u.viewColumn(j2));
                double v3 = v1 / v2;
                u.viewColumn(j1).assign(u.viewColumn(j2), PlusMult.plusMult(-v3));
            }
            u.viewColumn(j1).assign(Mult.div(this.length(u.viewColumn(j1))));
        }
        return u;
    }

    private double length(DoubleMatrix1D u) {
        double sum = 0.0;
        for (int i = 0; i < u.size(); ++i) {
            sum += u.get(i) * u.get(i);
        }
        return Math.sqrt(sum);
    }

    private DoubleMatrix2D calculateThetaHat(DoubleMatrix2D Y, DoubleMatrix2D phi) {
        if (this.isVerbose()) {
            System.out.println("Calculating theta hat.");
        }
        DoubleMatrix2D thetaHat = new Algebra().mult(Y, phi);
        thetaHat.assign(Mult.div(Y.columns()));
        return thetaHat;
    }

    private DoubleMatrix1D calculateSigmaHatSquared(DoubleMatrix2D thetaHat) {
        if (this.isVerbose()) {
            System.out.println("Calculating sigma hat squared.");
        }
        int n = thetaHat.rows();
        int m = thetaHat.columns();
        int L = m / 3;
        DenseDoubleMatrix1D sigmaHatSquared = new DenseDoubleMatrix1D(n);
        for (int i = 0; i < n; ++i) {
            if (this.isVerbose() && (i + 1) % 1000 == 0) {
                System.out.println(i + 1);
            }
            double sum = 0.0;
            for (int j = L; j < m; ++j) {
                double v = thetaHat.get(i, j);
                sum += v * v;
            }
            sigmaHatSquared.set(i, sum *= (double)m / (double)(m - L));
        }
        return sigmaHatSquared;
    }

    private void screenFlatCurvesFdr(int n, int m, DoubleMatrix2D thetaHat) {
        int i;
        if (this.isVerbose()) {
            System.out.println("Screening out flat curves using FDR.");
        }
        DenseDoubleMatrix1D T = new DenseDoubleMatrix1D(n);
        for (int i2 = 0; i2 < n; ++i2) {
            double sum = 0.0;
            for (int j = 1; j < m; ++j) {
                double v = thetaHat.get(i2, j);
                sum += v * v;
            }
            T.set(i2, sum);
        }
        int[] sumB = new int[n];
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i3 = 0; i3 < n; ++i3) {
            indices.add(i3);
        }
        for (int p = 0; p < 10000; ++p) {
            if (this.isVerbose()) {
                System.out.println("Shuffle " + p);
            }
            Collections.shuffle(indices);
            for (i = 0; i < n; ++i) {
                double tStar = 0.0;
                for (int j = 1; j < m; ++j) {
                    double v = thetaHat.get((Integer)indices.get(i), j);
                    tStar += v * v;
                }
                if (!(tStar > T.get(i))) continue;
                int n2 = i;
                sumB[n2] = sumB[n2] + 1;
            }
        }
        ArrayList<Double> pValues = new ArrayList<Double>();
        for (i = 0; i < n; ++i) {
            pValues.add(1.0E-4 * (double)sumB[i]);
        }
        ArrayList<Double> sortedPValues = new ArrayList<Double>(pValues);
        sortedPValues.add(0, 0.0);
        Collections.sort(sortedPValues);
        System.out.println("P values sorted " + sortedPValues);
        int _j = n - 1;
        double alpha = 0.05;
        for (int i4 = n; i4 >= 0; --i4) {
            double cutoff = (double)i4 * alpha / (double)n;
            Double ithPValue = (Double)sortedPValues.get(i4);
            if (!(ithPValue <= cutoff)) continue;
            _j = i4;
            break;
        }
        double T0 = (Double)sortedPValues.get(_j);
        ArrayList<Integer> rowMask = new ArrayList<Integer>();
        for (int i5 = 0; i5 < n; ++i5) {
            if ((Double)pValues.get(i5) >= T0) {
                rowMask.add(i5);
                continue;
            }
            System.out.println("Leaving out " + i5);
        }
        int[] _rowMask = new int[rowMask.size()];
        for (int i6 = 0; i6 < rowMask.size(); ++i6) {
            _rowMask[i6] = (Integer)rowMask.get(i6);
        }
        int[] allColumns = new int[m];
        for (int i7 = 0; i7 < m; ++i7) {
            allColumns[i7] = i7;
        }
        this.Y.viewSelection(_rowMask, allColumns);
    }

    private void screenFlatCurvesConfidenceBalls(int n, DoubleMatrix1D sigmaHatSquared, int m, int JHat, DoubleMatrix2D thetaHat) {
        for (int i = 0; i < n; ++i) {
            if (this.isVerbose()) {
                System.out.println("Screening out flat curves using confidence balls.");
            }
            double sigmaSquared = sigmaHatSquared.get(i);
            double sum1 = 0.0;
            for (int j = 0; j < m; ++j) {
                int c = j >= JHat ? 1 : 0;
                sum1 += 1.0;
                sum1 += (double)(1 - 2 * c) / (double)(m - JHat);
                double theta = this.theta(j, m, thetaHat);
                sum1 *= 4.0 * (theta - sigmaSquared) + sigmaSquared + 2.0 * sigmaSquared * sigmaSquared;
            }
            double sum2 = 0.0;
            for (int j = 0; j < m; ++j) {
                int c = j >= JHat ? 1 : 0;
                double theta = this.theta(j, m, thetaHat);
                sum2 += (double)(2 * c) / (double)(m - JHat) * this.positive(theta - sigmaSquared);
            }
            double tau = Math.sqrt(sum1 + (sum2 *= 4.0 * sigmaSquared));
            double quantile = ProbUtils.normalQuantile(0.05 / (double)n);
            double _rHat = (double)JHat * sigmaSquared / (double)m;
            for (int j = JHat; j < m; ++j) {
                _rHat += this.theta(j, m, thetaHat);
                _rHat += sigmaSquared / (double)m;
            }
            double sSquared = quantile * tau / Math.sqrt(m) + _rHat;
            DoubleMatrix1D v = thetaHat.viewRow(i);
            double distanceFromZero = 0.0;
            for (int j = 0; j < m; ++j) {
                double a = v.get(j);
                distanceFromZero += a * a;
            }
            if (!(distanceFromZero < sSquared)) continue;
            System.out.println("Get rid of " + i + "!");
        }
    }

    private DoubleMatrix2D calculateRHat(DoubleMatrix1D sigmaHatSquared, DoubleMatrix2D thetaHat) {
        if (this.isVerbose()) {
            System.out.println("Calculating R hat.");
        }
        int n = thetaHat.rows();
        int m = thetaHat.columns();
        DenseDoubleMatrix2D RHat = new DenseDoubleMatrix2D(n, m);
        for (int i = 0; i < n; ++i) {
            if (this.isVerbose() && (i + 1) % 1000 == 0) {
                System.out.println(i + 1);
            }
            for (int J = 0; J < m; ++J) {
                double sum = (double)J * sigmaHatSquared.get(i) / (double)m;
                for (int j = J; j < m; ++j) {
                    double v = thetaHat.get(i, j);
                    double value = v * v - sigmaHatSquared.get(i) / (double)m;
                    sum += this.positive(value);
                }
                RHat.set(i, J, sum);
            }
        }
        return RHat;
    }

    private DoubleMatrix2D calculateLittleRHat(DoubleMatrix2D RHat) {
        if (this.isVerbose()) {
            System.out.println("Calculating r hat.");
        }
        int n = RHat.rows();
        int m = RHat.columns();
        DenseDoubleMatrix2D rHat = new DenseDoubleMatrix2D(n, m);
        for (int i = 0; i < n; ++i) {
            int j;
            if (this.isVerbose() && (i + 1) % 1000 == 0) {
                System.out.println(i + 1);
            }
            double min = Double.POSITIVE_INFINITY;
            for (j = 0; j < m; ++j) {
                if (!(RHat.get(i, j) < min)) continue;
                min = RHat.get(i, j);
            }
            for (j = 0; j < RHat.columns(); ++j) {
                rHat.set(i, j, RHat.get(i, j) - min);
            }
        }
        return rHat;
    }

    private DoubleMatrix1D calculateT(DoubleMatrix2D rHat) {
        if (this.isVerbose()) {
            System.out.println("Calculating t.");
        }
        int n = rHat.rows();
        int m = rHat.columns();
        DenseDoubleMatrix1D t = new DenseDoubleMatrix1D(m);
        for (int J = 0; J < m; ++J) {
            double sum = 0.0;
            for (int i = 0; i < n; ++i) {
                sum += rHat.get(i, J);
            }
            t.set(J, sum);
        }
        return t;
    }

    private int calculateJHat(int m, DoubleMatrix1D t) {
        if (this.isVerbose()) {
            System.out.println("Calculating J hat.");
        }
        int JHat = Integer.MAX_VALUE;
        double minT = Double.POSITIVE_INFINITY;
        for (int J = 0; J < m; ++J) {
            if (!(t.get(J) < minT)) continue;
            minT = t.get(J);
            JHat = J;
        }
        if (this.isVerbose()) {
            System.out.println("JHat = " + JHat);
        }
        return JHat;
    }

    private void calculateFHat(int n, int m, int JHat, DoubleMatrix2D phi) {
        if (this.isVerbose()) {
            System.out.println("Calculating f hat.");
        }
        DenseDoubleMatrix2D fHat = new DenseDoubleMatrix2D(n, m);
        for (int i = 0; i < n; ++i) {
            if (this.isVerbose() && (i + 1) % 1000 == 0) {
                System.out.println(i + 1);
            }
            for (int r = 0; r < m; ++r) {
                double sum = 0.0;
                for (int j = 0; j <= JHat; ++j) {
                    sum += this.Y.get(i, j) * phi.get(r, j);
                }
                fHat.set(i, r, sum /= (double)m);
            }
        }
        this.fHat = fHat;
    }

    private double theta(int j, int m, DoubleMatrix2D thetaHat) {
        double theta = 0.0;
        for (int r = 0; r < m; ++r) {
            theta += thetaHat.get(r, j);
        }
        return theta;
    }

    private DoubleMatrix2D calculateThetaTilde(DoubleMatrix2D thetaHat, int n, int JHat) {
        if (this.isVerbose()) {
            System.out.println("Restricting theta to smoothed components.");
        }
        int m0 = thetaHat.columns() - 1;
        DoubleMatrix2D thetaHatRestriction = thetaHat.viewPart(0, 1, n, m0);
        for (int i = 0; i < n; ++i) {
            DoubleMatrix1D v = thetaHatRestriction.viewRow(i);
            double sum = 0.0;
            for (int j = 0; j < m0; ++j) {
                double vj = v.get(j);
                sum += vj * vj;
            }
            double norm = Math.sqrt(sum);
            v.assign(Mult.div(norm));
        }
        thetaHatRestriction = thetaHatRestriction.viewPart(0, 0, n, JHat);
        return thetaHatRestriction;
    }

    private double t(int i, int n) {
        return (double)i / (double)(n - 1);
    }

    private double phi(int j, double t) {
        if (!(t >= 0.0) || !(t <= 1.0)) {
            throw new IllegalArgumentException("t must be in [0, 1]: " + t);
        }
        return SQRT2 * Math.cos((double)j * Math.PI * t);
    }

    private double positive(double value) {
        return value > 0.0 ? value : 0.0;
    }
}

