/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.cluster;

import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.DoubleMatrix2D;
import cern.jet.stat.Descriptive;
import edu.cmu.tetrad.cluster.ClusteringAlgorithm;
import edu.cmu.tetrad.cluster.metrics.SquaredErrorLoss;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class Cba2
implements ClusteringAlgorithm {
    private DoubleMatrix2D xyzCoords;
    private boolean verbose = true;

    public Cba2(DoubleMatrix2D xyzCoords) {
        this.xyzCoords = xyzCoords;
    }

    @Override
    public void cluster(DoubleMatrix2D timeSeries) {
        int i;
        int z;
        int y;
        int x;
        SquaredErrorLoss metric = new SquaredErrorLoss();
        DoubleArrayList cluster0 = new DoubleArrayList(this.xyzCoords.viewColumn(0).toArray());
        DoubleArrayList cluster1 = new DoubleArrayList(this.xyzCoords.viewColumn(1).toArray());
        DoubleArrayList cluster2 = new DoubleArrayList(this.xyzCoords.viewColumn(2).toArray());
        int minX = (int)Descriptive.min(cluster0);
        int minY = (int)Descriptive.min(cluster1);
        int minZ = (int)Descriptive.min(cluster2);
        int maxX = (int)Descriptive.max(cluster0);
        int maxY = (int)Descriptive.max(cluster1);
        int maxZ = (int)Descriptive.max(cluster2);
        double mean0 = Descriptive.mean(cluster0);
        double mean1 = Descriptive.mean(cluster1);
        double mean2 = Descriptive.mean(cluster2);
        double sd0 = this.standardDeviation(cluster0);
        double sd1 = this.standardDeviation(cluster1);
        double sd2 = this.standardDeviation(cluster2);
        System.out.println("X = " + minX + " to " + maxX + " mean = " + mean0 + " SD = " + sd0);
        System.out.println("Y = " + minY + " to " + maxY + " mean = " + mean1 + " SD = " + sd1);
        System.out.println("Z = " + minZ + " to " + maxZ + " mean = " + mean2 + " SD = " + sd2);
        int[][][] brainMap = new int[maxX - minX + 1][maxY - minY + 1][maxZ - minZ + 1];
        for (int x2 = minX; x2 <= maxX; ++x2) {
            for (int y2 = minY; y2 <= maxY; ++y2) {
                for (int z2 = minZ; z2 <= maxZ; ++z2) {
                    brainMap[x2 - minX][y2 - minY][z2 - minZ] = -1;
                }
            }
        }
        int i2 = 0;
        while (i2 < this.xyzCoords.rows()) {
            x = (int)this.xyzCoords.get(i2, 0);
            y = (int)this.xyzCoords.get(i2, 1);
            z = (int)this.xyzCoords.get(i2, 2);
            brainMap[x - minX][y - minY][z - minZ] = i2++;
        }
        ArrayList protoClusters = new ArrayList();
        for (i = 0; i < this.xyzCoords.rows(); ++i) {
            protoClusters.add(new LinkedHashSet());
        }
        for (x = minX; x <= maxX; ++x) {
            System.out.println("x = " + x);
            for (y = minY; y <= maxY; ++y) {
                for (z = minZ; z <= maxZ; ++z) {
                    int i1 = brainMap[x - minX][y - minY][z - minZ];
                    if (i1 == -1) continue;
                    int centerPoint = brainMap[x - minX][y - minY][z - minZ];
                    ((Set)protoClusters.get(centerPoint)).add(centerPoint);
                    for (int _x = x - 1; _x <= x + 1; ++_x) {
                        for (int _y = y - 1; _y <= y + 1; ++_y) {
                            for (int _z = z - 1; _z <= z + 1; ++_z) {
                                double v;
                                int i22;
                                if (_x < minX || _x > maxX || _y < minY || _y > maxY || _z < minZ || _z > maxZ || _x == x && _y == y && _z == z || (i22 = brainMap[_x - minX][_y - minY][_z - minZ]) == -1 || !((v = metric.dissimilarity(timeSeries.viewRow(i1), timeSeries.viewRow(i22))) < 0.001)) continue;
                                int otherPoint = brainMap[_x - minX][_y - minY][_z - minZ];
                                ((Set)protoClusters.get(centerPoint)).add(otherPoint);
                            }
                        }
                    }
                }
            }
        }
        for (i = 0; i < protoClusters.size(); ++i) {
            System.out.println("i = " + i);
            if (protoClusters.get(i) == null) continue;
            block12: for (int j = i + 1; j < protoClusters.size(); ++j) {
                if (protoClusters.get(j) == null) continue;
                Iterator i$ = ((Set)protoClusters.get(j)).iterator();
                while (i$.hasNext()) {
                    int k = (Integer)i$.next();
                    if (!((Set)protoClusters.get(i)).contains(k)) continue;
                    ((Set)protoClusters.get(i)).addAll((Collection)protoClusters.get(j));
                    protoClusters.set(j, null);
                    continue block12;
                }
            }
        }
        ArrayList clusters = new ArrayList();
        int minSize = Integer.MAX_VALUE;
        int maxSize = Integer.MIN_VALUE;
        for (int i3 = 0; i3 < protoClusters.size(); ++i3) {
            Set cluster = (Set)protoClusters.get(i3);
            if (cluster == null) continue;
            int size = cluster.size();
            clusters.add(protoClusters.get(i3));
            if (size < minSize) {
                minSize = size;
            }
            if (size <= maxSize) continue;
            maxSize = size;
        }
        System.out.println(clusters.size() + " clusters");
        System.out.println("Min size = " + minSize);
        System.out.println("Max size = " + maxSize);
    }

    public void findNeighbors(DoubleMatrix2D timeSeries) {
        SquaredErrorLoss metric = new SquaredErrorLoss();
        int row = RandomUtil.getInstance().nextInt(this.xyzCoords.rows());
        int x1 = (int)this.xyzCoords.get(row, 0);
        int y1 = (int)this.xyzCoords.get(row, 1);
        int z1 = (int)this.xyzCoords.get(row, 2);
        DoubleArrayList cluster0 = new DoubleArrayList(this.xyzCoords.viewColumn(0).toArray());
        DoubleArrayList cluster1 = new DoubleArrayList(this.xyzCoords.viewColumn(1).toArray());
        DoubleArrayList cluster2 = new DoubleArrayList(this.xyzCoords.viewColumn(2).toArray());
        int minX = (int)Descriptive.min(cluster0);
        int minY = (int)Descriptive.min(cluster1);
        int minZ = (int)Descriptive.min(cluster2);
        int maxX = (int)Descriptive.max(cluster0);
        int maxY = (int)Descriptive.max(cluster1);
        int maxZ = (int)Descriptive.max(cluster2);
        double mean0 = Descriptive.mean(cluster0);
        double mean1 = Descriptive.mean(cluster1);
        double mean2 = Descriptive.mean(cluster2);
        double sd0 = this.standardDeviation(cluster0);
        double sd1 = this.standardDeviation(cluster1);
        double sd2 = this.standardDeviation(cluster2);
        System.out.println("X = " + minX + " to " + maxX + " mean = " + mean0 + " SD = " + sd0);
        System.out.println("Y = " + minY + " to " + maxY + " mean = " + mean1 + " SD = " + sd1);
        System.out.println("Z = " + minZ + " to " + maxZ + " mean = " + mean2 + " SD = " + sd2);
        int[][][] brainMap = new int[maxX - minX + 1][maxY - minY + 1][maxZ - minZ + 1];
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    brainMap[x - minX][y - minY][z - minZ] = -1;
                }
            }
        }
        int i = 0;
        while (i < this.xyzCoords.rows()) {
            int x = (int)this.xyzCoords.get(i, 0);
            int y = (int)this.xyzCoords.get(i, 1);
            int z = (int)this.xyzCoords.get(i, 2);
            brainMap[x - minX][y - minY][z - minZ] = i++;
        }
        ArrayList protoClusters = new ArrayList();
        for (int i2 = 0; i2 < this.xyzCoords.rows(); ++i2) {
            protoClusters.add(new LinkedHashSet());
        }
        int i1 = brainMap[x1 - minX][y1 - minY][z1 - minZ];
        if (i1 == -1) {
            throw new IllegalArgumentException();
        }
        System.out.println("*** x = " + x1 + " y = " + y1 + " z = " + z1);
        int centerPoint = brainMap[x1 - minX][y1 - minY][z1 - minZ];
        ((Set)protoClusters.get(centerPoint)).add(centerPoint);
        int scope = 5;
        ArrayList<Tuple> pairs = new ArrayList<Tuple>();
        for (int _x = x1 - scope; _x <= x1 + scope; ++_x) {
            for (int _y = y1 - scope; _y <= y1 + scope; ++_y) {
                for (int _z = z1 - scope; _z <= z1 + scope; ++_z) {
                    int i2;
                    if (_x < minX || _x > maxX || _y < minY || _y > maxY || _z < minZ || _z > maxZ || _x == x1 && _y == y1 && _z == z1 || (i2 = brainMap[_x - minX][_y - minY][_z - minZ]) == -1) continue;
                    double[] array1 = timeSeries.viewRow(i1).toArray();
                    double[] array2 = timeSeries.viewRow(i2).toArray();
                    double correlation = this.correlation(array1, array2);
                    int otherPoint = brainMap[_x - minX][_y - minY][_z - minZ];
                    ((Set)protoClusters.get(centerPoint)).add(otherPoint);
                    double distance = this.distance(x1, y1, z1, _x, _y, _z);
                    pairs.add(new Tuple(distance, correlation, otherPoint));
                }
            }
        }
        Collections.sort(pairs);
        for (Tuple pair : pairs) {
            double distance = pair.distance;
            double correlation = pair.correlation;
            int x2 = (int)this.xyzCoords.get(pair.point, 0);
            int y2 = (int)this.xyzCoords.get(pair.point, 1);
            int z2 = (int)this.xyzCoords.get(pair.point, 2);
            System.out.println(distance + " " + correlation + " <" + x2 + ", " + y2 + ", " + z2 + ">");
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private double correlation(double[] array1, double[] array2) {
        DoubleArrayList list1 = new DoubleArrayList(array1);
        DoubleArrayList list2 = new DoubleArrayList(array2);
        double ss1 = Descriptive.sumOfSquares(list1);
        double ss2 = Descriptive.sumOfSquares(list2);
        double s1 = Descriptive.sum(list1);
        double s2 = Descriptive.sum(list2);
        double var1 = Descriptive.variance(list1.size(), s1, ss1);
        double var2 = Descriptive.variance(list2.size(), s2, ss2);
        double v = Descriptive.correlation(list1, Descriptive.standardDeviation(var1), list2, Descriptive.standardDeviation(var2));
        return v;
    }

    @Override
    public List<List<Integer>> getClusters() {
        return null;
    }

    @Override
    public DoubleMatrix2D getPrototypes() {
        return null;
    }

    private double distance(int x, int y, int z, int x1, int y1, int z1) {
        int d1 = x - x1;
        int d2 = y - y1;
        int d3 = z - z1;
        return Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
    }

    private double standardDeviation(DoubleArrayList cluster) {
        double sumX = Descriptive.sum(cluster);
        double sumSqX = Descriptive.sumOfSquares(cluster);
        double variance = Descriptive.variance(cluster.size(), sumX, sumSqX);
        return Descriptive.standardDeviation(variance);
    }

    private static class Tuple
    implements Comparable {
        public double distance;
        public double correlation;
        public int point;

        public Tuple(double distance, double correlation, int point) {
            this.distance = distance;
            this.correlation = correlation;
            this.point = point;
        }

        public int compareTo(Object o) {
            Tuple p = (Tuple)o;
            return p.distance > this.distance ? -1 : (p.distance == this.distance ? 0 : 1);
        }
    }
}

