/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.cluster;

import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.cluster.Cluster;
import edu.cmu.tetrad.cluster.ClusteringAlgorithm;
import edu.cmu.tetrad.cluster.metrics.Dissimilarity;
import edu.cmu.tetrad.cluster.metrics.SquaredErrorLoss;
import edu.cmu.tetrad.util.Point;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Dmc
implements ClusteringAlgorithm {
    private List<Point> points;
    private List<Cluster> clusters;
    private int densityTreshold = 20;
    private double neighborDistance = 2.5;
    private Dissimilarity metric = new SquaredErrorLoss();
    private boolean verbose = true;

    private Dmc() {
    }

    public static Dmc rjSearch() {
        return new Dmc();
    }

    @Override
    public void cluster(DoubleMatrix2D data) {
        Point p;
        int i;
        this.points = new ArrayList<Point>();
        for (int i2 = 0; i2 < data.rows(); ++i2) {
            this.points.add(new Point(data.viewRow(i2)));
        }
        System.out.println("# thresholded points = " + this.points.size() + ", k = " + this.getDensityTreshold() + ", r = " + this.getNeighborDistance());
        ArrayList<Point> densePoints = new ArrayList<Point>();
        List<Cluster> clusters = new ArrayList<Cluster>();
        for (i = 0; i < this.points.size(); ++i) {
            if (this.isVerbose() && i % 1000 == 0) {
                System.out.println(i);
            }
            p = this.points.get(i);
            int count = 0;
            for (Point q : this.points) {
                double v1;
                double v = this.distance(p, q);
                if (!(v < (v1 = this.getNeighborDistance()))) continue;
                ++count;
            }
            if (count <= this.getDensityTreshold()) continue;
            if (this.isVerbose()) {
                // empty if block
            }
            densePoints.add(p);
        }
        if (this.isVerbose()) {
            System.out.println("# dense points = " + densePoints.size());
        }
        if (this.isVerbose()) {
            System.out.println("Merging dense point clusters.");
        }
        for (i = 0; i < densePoints.size(); ++i) {
            if (this.isVerbose() && (i + 1) % 1000 == 0) {
                System.out.println(i + 1);
            }
            p = (Point)densePoints.get(i);
            LinkedList<Integer> foundIndices = new LinkedList<Integer>();
            block4: for (int j = 0; j < clusters.size(); ++j) {
                Cluster cluster = clusters.get(j);
                if (cluster == null) continue;
                for (Point q : cluster.getPoints()) {
                    if (p == q || !(this.distance(p, q) < 4.0)) continue;
                    foundIndices.add(j);
                    continue block4;
                }
            }
            if (foundIndices.size() == 0) {
                clusters.add(Cluster.pointCluster(p));
            }
            if (foundIndices.size() == 1) {
                clusters.get((Integer)foundIndices.get(0)).addPoint(p);
                continue;
            }
            if (foundIndices.size() <= 1) continue;
            Cluster cluster = Cluster.emptyCluster();
            for (Integer index : foundIndices) {
                cluster.merge(clusters.get(index));
                clusters.set(index, null);
            }
            cluster.addPoint(p);
            clusters.add(cluster);
        }
        clusters = this.removeNulls(clusters);
        if (this.isVerbose()) {
            System.out.println("Initial phase -- # clusters = " + clusters.size());
        }
        for (i = 0; i < clusters.size(); ++i) {
            for (int j = i + 1; j < clusters.size(); ++j) {
                Cluster ci = clusters.get(i);
                Cluster cj = clusters.get(j);
                if (ci == null || cj == null || !this.mergeable(ci, cj)) continue;
                clusters.set(i, null);
                clusters.set(j, null);
                Cluster d = Cluster.emptyCluster();
                d.merge(ci);
                d.merge(cj);
                clusters.add(d);
                if (!this.isVerbose()) continue;
                System.out.println("Merging clusters " + i + " and " + j);
                this.printNonNullClusters(clusters);
            }
        }
        this.clusters = this.removeNulls(clusters);
        System.out.println("Merging phase -- # clusters = " + this.clusters.size());
    }

    @Override
    public List<List<Integer>> getClusters() {
        ArrayList<List<Integer>> _clusters = new ArrayList<List<Integer>>();
        for (int i = 0; i < this.clusters.size(); ++i) {
            Cluster cluster = this.clusters.get(i);
            ArrayList<Integer> _cluster = new ArrayList<Integer>();
            for (Point p : cluster.getPoints()) {
                _cluster.add(this.points.indexOf(p));
            }
            _clusters.add(_cluster);
        }
        return _clusters;
    }

    @Override
    public DoubleMatrix2D getPrototypes() {
        return null;
    }

    private void writePointsToFile(List<Point> points) {
        try {
            File file = new File("/home/jdramsey/points.dat");
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter out = new PrintWriter(fileWriter);
            for (Point point : points) {
                out.println(point.getValue(2) + " " + point.getValue(0) + " " + (72.0 - point.getValue(1)));
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void printNonNullClusters(List<Cluster> clusters) {
        for (int k = 0; k < clusters.size(); ++k) {
            Cluster cluster = clusters.get(k);
            if (cluster == null) continue;
            System.out.print(k + " ");
        }
        System.out.println();
    }

    private List<Cluster> removeNulls(List<Cluster> clusters) {
        ArrayList<Cluster> absentNulls = new ArrayList<Cluster>();
        for (Cluster cluster : clusters) {
            if (cluster == null) continue;
            absentNulls.add(cluster);
        }
        return absentNulls;
    }

    private boolean mergeable(Cluster ci, Cluster cj) {
        return this.romeoAndJuliutRule(ci, cj);
    }

    private boolean averageLinkageRule(Cluster ci, Cluster cj) {
        double threshold = 10.0;
        double sum = 0.0;
        for (Point pPrime : ci.getPoints()) {
            for (Point qPrime : cj.getPoints()) {
                for (int k = 0; k < pPrime.getSize(); ++k) {
                    sum += this.distance(pPrime, qPrime);
                }
            }
        }
        return sum / (ci.size() * cj.size()) < threshold;
    }

    private boolean romeoAndJuliutRule(Cluster ci, Cluster cj) {
        Point p = null;
        Point q = null;
        double leastDistance = Double.POSITIVE_INFINITY;
        for (Point pPrime : ci.getPoints()) {
            block1: for (Point qPrime : cj.getPoints()) {
                for (int k = 0; k < pPrime.getSize(); ++k) {
                    if (Math.abs(pPrime.getValue(k) - qPrime.getValue(k)) > leastDistance) continue block1;
                }
                double distance = this.distance(pPrime, qPrime);
                if (!(distance < leastDistance)) continue;
                p = pPrime;
                q = qPrime;
                leastDistance = distance;
            }
        }
        if (p == null || q == null) {
            throw new IllegalStateException("Impossible to get here.");
        }
        double a = 0.0;
        for (Point x : ci.getPoints()) {
            a += this.distance(p, x);
        }
        a /= ci.size();
        double b = 0.0;
        for (Point y : cj.getPoints()) {
            b += this.distance(q, y);
        }
        return leastDistance < (a + (b /= cj.size())) / 2.0;
    }

    private double distance(Point p, Point q) {
        return this.metric.dissimilarity(p.getVector(), q.getVector());
    }

    public String toString() {
        return this.printableClusterString(this.clusters);
    }

    private String printableClusterString(List<Cluster> clusters) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (Cluster cluster : clusters) {
            System.out.println("Cluster # " + ++i + " size = " + cluster.size() + " " + cluster);
        }
        return buf.toString();
    }

    public int getDensityTreshold() {
        return this.densityTreshold;
    }

    public void setDensityTreshold(int densityTreshold) {
        this.densityTreshold = densityTreshold;
    }

    public double getNeighborDistance() {
        return this.neighborDistance;
    }

    public void setNeighborDistance(double neighborDistance) {
        this.neighborDistance = neighborDistance;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

