/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataBox;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.ShortDataBox;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetrad.util.TetradSerializable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class BoxDataSet
implements DataSet,
TetradSerializable {
    static final long serialVersionUID = 23L;
    private Map<String, String> columnToTooltip;
    private String name;
    private List<Node> variables = new ArrayList<Node>();
    private DataBox dataBox;
    private Set<Node> selection = new HashSet<Node>();
    private Map<Integer, String> caseIds = new HashMap<Integer, String>();
    private Map<Integer, Integer> multipliers = new HashMap<Integer, Integer>();
    private Knowledge knowledge = new Knowledge();
    private boolean newCategoriesAccomodated = true;
    private transient NumberFormat nf;
    private char outputDelimiter = (char)9;

    @Override
    public Map<String, String> getColumnToTooltip() {
        return this.columnToTooltip;
    }

    @Override
    public void setColumnToTooltip(Map<String, String> columnToTooltip) {
        this.columnToTooltip = columnToTooltip;
    }

    public BoxDataSet(DataBox dataBox, List<Node> variables) {
        this.dataBox = dataBox;
        this.variables = variables;
    }

    public BoxDataSet(BoxDataSet dataSet) {
        this.name = dataSet.name;
        this.variables = new LinkedList<Node>(dataSet.variables);
        this.dataBox = dataSet.dataBox.copy();
        this.selection = new HashSet<Node>(dataSet.selection);
        this.multipliers = new HashMap<Integer, Integer>(dataSet.multipliers);
        this.knowledge = new Knowledge(dataSet.knowledge);
        this.newCategoriesAccomodated = dataSet.newCategoriesAccomodated;
    }

    public static BoxDataSet serializableInstance() {
        return new BoxDataSet(new ShortDataBox(4, 4), null);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        this.name = name;
    }

    @Override
    public final int getNumColumns() {
        return this.variables.size();
    }

    @Override
    public final int getNumRows() {
        return this.dataBox.numRows();
    }

    @Override
    public final void setInt(int row, int column, int value) {
        Node variable = this.getVariable(column);
        if (!(variable instanceof DiscreteVariable)) {
            throw new IllegalArgumentException("Can only set ints for discrete columns.");
        }
        DiscreteVariable _variable = (DiscreteVariable)variable;
        if (value < 0 && value != -99) {
            throw new IllegalArgumentException("Value must be a positive integer: " + value);
        }
        if (value >= _variable.getNumCategories()) {
            if (_variable.isAccommodateNewCategories()) {
                this.accomodateIndex(_variable, value);
            } else {
                throw new IllegalArgumentException("Not a value for that variable: " + value);
            }
        }
        try {
            this.setIntPrivate(row, column, value);
        }
        catch (Exception e) {
            if (row < 0 || column < 0) {
                throw new IllegalArgumentException("Row and column must be >= 0.");
            }
            int newRows = Math.max(row + 1, this.dataBox.numRows());
            int newCols = Math.max(column + 1, this.dataBox.numCols());
            this.resize(newRows, newCols);
            this.setIntPrivate(row, column, value);
        }
    }

    @Override
    public final void setDouble(int row, int column, double value) {
        if (!(this.getVariable(column) instanceof ContinuousVariable)) {
            throw new IllegalArgumentException("Can only set ints for discrete columns: " + this.getVariable(column));
        }
        try {
            this.dataBox.set(row, column, value);
        }
        catch (Exception e) {
            if (row < 0 || column < 0) {
                throw new IllegalArgumentException("Row and column must be >= 0.");
            }
            int newRows = Math.max(row + 1, this.dataBox.numRows());
            int newCols = Math.max(column + 1, this.dataBox.numCols());
            this.resize(newRows, newCols);
            this.dataBox.set(row, column, value);
        }
    }

    @Override
    public final Object getObject(int row, int col) {
        Node variable = this.getVariable(col);
        if (variable instanceof ContinuousVariable) {
            return this.getDouble(row, col);
        }
        if (variable instanceof DiscreteVariable) {
            DiscreteVariable _variable = (DiscreteVariable)variable;
            if (_variable.isCategoryNamesDisplayed()) {
                return _variable.getCategory(this.getInt(row, col));
            }
            return this.getInt(row, col);
        }
        throw new IllegalArgumentException("Not a row/col in this data set.");
    }

    @Override
    public final void setObject(int row, int col, Object value) {
        Node variable = this.getVariable(col);
        if (variable instanceof ContinuousVariable) {
            this.setDouble(row, col, BoxDataSet.getValueFromObjectContinuous(value));
        } else if (variable instanceof DiscreteVariable) {
            this.setInt(row, col, this.getValueFromObjectDiscrete(value, (DiscreteVariable)variable));
        } else {
            throw new IllegalArgumentException("Expecting either a continuous or a discrete variable.");
        }
    }

    @Override
    public final int[] getSelectedIndices() {
        List<Node> variables = this.getVariables();
        Set<Node> selection = this.getSelection();
        int[] indices = new int[selection.size()];
        int j = -1;
        for (int i = 0; i < variables.size(); ++i) {
            if (!selection.contains(variables.get(i))) continue;
            indices[++j] = i;
        }
        return indices;
    }

    public final Set<Node> getSelectedVariables() {
        return new HashSet<Node>(this.selection);
    }

    @Override
    public final void addVariable(Node variable) {
        if (this.variables.contains(variable)) {
            throw new IllegalArgumentException("Expecting a new variable: " + variable);
        }
        this.variables.add(variable);
        this.resize(this.dataBox.numRows(), this.variables.size());
        int col = this.dataBox.numCols() - 1;
        for (int i = 0; i < this.dataBox.numRows(); ++i) {
            this.dataBox.set(i, col, null);
        }
    }

    @Override
    public final void addVariable(int index, Node variable) {
        if (this.variables.contains(variable)) {
            throw new IllegalArgumentException("Expecting a new variable.");
        }
        if (index < 0 || index > this.variables.size()) {
            throw new IndexOutOfBoundsException("Index must in (0, #vars).");
        }
        this.variables.add(index, variable);
        this.resize(this.dataBox.numRows(), this.variables.size());
        Number[][] _data = new Number[this.dataBox.numRows()][this.dataBox.numCols()];
        for (int j = 0; j < this.dataBox.numCols() + 1; ++j) {
            int i;
            if (j < index) {
                for (i = 0; i < this.dataBox.numRows(); ++i) {
                    _data[i][j] = this.dataBox.get(i, j);
                }
                continue;
            }
            if (j == index) {
                for (i = 0; i < this.dataBox.numRows(); ++i) {
                    _data[i][j] = null;
                }
                continue;
            }
            for (i = 0; i < this.dataBox.numRows(); ++i) {
                _data[i][j] = this.dataBox.get(i, j - 1);
            }
        }
    }

    @Override
    public final Node getVariable(int col) {
        return this.variables.get(col);
    }

    @Override
    public final int getColumn(Node variable) {
        return this.variables.indexOf(variable);
    }

    @Override
    public final void changeVariable(Node from, Node to) {
        int i;
        if (!(from instanceof DiscreteVariable) || !(to instanceof DiscreteVariable)) {
            throw new IllegalArgumentException("Only discrete variables supported.");
        }
        DiscreteVariable _from = (DiscreteVariable)from;
        DiscreteVariable _to = (DiscreteVariable)to;
        int col = this.variables.indexOf(_from);
        List<String> oldCategories = _from.getCategories();
        List<String> newCategories = _to.getCategories();
        int[] indexArray = new int[oldCategories.size()];
        for (i = 0; i < oldCategories.size(); ++i) {
            indexArray[i] = newCategories.indexOf(oldCategories.get(i));
        }
        for (i = 0; i < this.getNumRows() && this.dataBox.get(i, col) != null; ++i) {
            int value = this.getInt(i, col);
            int newIndex = 0;
            try {
                newIndex = indexArray[value];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (newIndex == -1) {
                this.dataBox.set(i, col, null);
                continue;
            }
            this.setInt(i, col, newIndex);
        }
        this.variables.set(col, _to);
    }

    @Override
    public final Node getVariable(String varName) {
        for (Node variable1 : this.variables) {
            if (!variable1.getName().equals(varName)) continue;
            return variable1;
        }
        return null;
    }

    @Override
    public final List<Node> getVariables() {
        return new LinkedList<Node>(this.variables);
    }

    @Override
    public final Knowledge getKnowledge() {
        return new Knowledge(this.knowledge);
    }

    @Override
    public final void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public final List<String> getVariableNames() {
        List<Node> vars = this.getVariables();
        ArrayList<String> names = new ArrayList<String>();
        for (Node variable : vars) {
            String name = variable.getName();
            names.add(name);
        }
        return names;
    }

    @Override
    public final void setSelected(Node variable, boolean selected) {
        if (selected) {
            if (this.variables.contains(variable)) {
                this.getSelection().add(variable);
            }
        } else if (this.variables.contains(variable)) {
            this.getSelection().remove(variable);
        }
    }

    @Override
    public final void clearSelection() {
        this.getSelection().clear();
    }

    @Override
    public void ensureRows(int rows) {
        if (rows > this.getNumRows()) {
            this.resize(rows, this.getNumColumns());
        }
    }

    @Override
    public void ensureColumns(int columns, List<String> excludedVariableNames) {
        for (int col = this.getNumColumns(); col < columns; ++col) {
            String _name;
            int i = 0;
            while (this.getVariable(_name = "X" + ++i) != null || excludedVariableNames.contains(_name)) {
            }
            ContinuousVariable variable = new ContinuousVariable(_name);
            this.addVariable(variable);
        }
    }

    @Override
    public final boolean isSelected(Node variable) {
        return this.getSelection().contains(variable);
    }

    @Override
    public final void removeColumn(int index) {
        if (index < 0 || index >= this.variables.size()) {
            throw new IllegalArgumentException("Not a column in this data set: " + index);
        }
        this.variables.remove(index);
        int[] rows = new int[this.dataBox.numRows()];
        for (int i = 0; i < this.dataBox.numRows(); ++i) {
            rows[i] = i;
        }
        int[] cols = new int[this.dataBox.numCols() - 1];
        int m = -1;
        for (int i = 0; i < this.dataBox.numCols(); ++i) {
            if (i == index) continue;
            cols[++m] = i;
        }
        this.dataBox = this.viewSelection(rows, cols);
    }

    private DataBox viewSelection(int[] rows, int[] cols) {
        DataBox _dataBox = this.dataBox.like(rows.length, cols.length);
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < cols.length; ++j) {
                _dataBox.set(i, j, this.dataBox.get(rows[i], cols[j]));
            }
        }
        return _dataBox;
    }

    @Override
    public final void removeColumn(Node variable) {
        int index = this.variables.indexOf(variable);
        if (index != -1) {
            this.removeColumn(index);
        }
    }

    @Override
    public final DataSet subsetColumns(List<Node> vars) {
        if (!this.getVariables().containsAll(vars)) {
            ArrayList<Node> missingVars = new ArrayList<Node>(vars);
            missingVars.removeAll(this.getVariables());
            throw new IllegalArgumentException("All vars must be original vars: " + missingVars);
        }
        int[] rows = new int[this.dataBox.numRows()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = i;
        }
        int[] cols = new int[vars.size()];
        for (int j = 0; j < cols.length; ++j) {
            cols[j] = this.getVariables().indexOf(vars.get(j));
        }
        DataBox _dataBox = this.viewSelection(rows, cols);
        BoxDataSet _dataSet = new BoxDataSet(_dataBox, vars);
        _dataSet.variables = vars;
        _dataSet.selection = new HashSet<Node>();
        _dataSet.multipliers = new HashMap<Integer, Integer>(this.multipliers);
        _dataSet.knowledge = new Knowledge(this.knowledge);
        return _dataSet;
    }

    @Override
    public final boolean isMulipliersCollapsed() {
        return !this.getMultipliers().keySet().isEmpty();
    }

    @Override
    public final int getMultiplier(int caseNumber) {
        Integer multiplierInt = this.getMultipliers().get(caseNumber);
        return multiplierInt == null ? 1 : multiplierInt;
    }

    @Override
    public final void setCaseId(int caseNumber, String id) {
        if (id == null) {
            this.caseIds.remove(caseNumber);
        } else {
            if (this.caseIds.values().contains(id)) {
                throw new IllegalArgumentException("Case ID's must be unique; that one has already been used: " + id);
            }
            this.caseIds.put(caseNumber, id);
        }
    }

    @Override
    public final String getCaseId(int caseNumber) {
        return this.caseIds.get(caseNumber);
    }

    @Override
    public final boolean isContinuous() {
        for (int i = 0; i < this.getNumColumns(); ++i) {
            Node variable = this.variables.get(i);
            if (variable instanceof ContinuousVariable) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isDiscrete() {
        for (int i = 0; i < this.getNumColumns(); ++i) {
            Node column = this.variables.get(i);
            if (column instanceof DiscreteVariable) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isMixed() {
        int numContinuous = 0;
        int numDiscrete = 0;
        for (int i = 0; i < this.getNumColumns(); ++i) {
            Node column = this.variables.get(i);
            if (column instanceof ContinuousVariable) {
                ++numContinuous;
                continue;
            }
            if (column instanceof DiscreteVariable) {
                ++numDiscrete;
                continue;
            }
            throw new IllegalArgumentException("Column not of type continuousor of type discrete; can't classify this data set.");
        }
        return numContinuous > 0 && numDiscrete > 0;
    }

    @Override
    public final DoubleMatrix2D getCorrelationMatrix() {
        if (!this.isContinuous()) {
            throw new IllegalStateException("Not a continuous data set.");
        }
        DenseDoubleMatrix2D cov = new DenseDoubleMatrix2D(this.dataBox.numCols(), this.dataBox.numCols());
        double[] x = new double[this.dataBox.numRows()];
        double[] y = new double[this.dataBox.numRows()];
        for (int i = 0; i < this.dataBox.numCols(); ++i) {
            for (int j = 0; j < this.dataBox.numCols(); ++j) {
                for (int k = 0; k < this.dataBox.numRows(); ++k) {
                    x[k] = this.dataBox.get(k, i).doubleValue();
                    y[k] = this.dataBox.get(k, j).doubleValue();
                    cov.set(i, j, StatUtils.correlation(x, y));
                }
            }
        }
        return cov;
    }

    @Override
    public final DoubleMatrix2D getCovarianceMatrix() {
        if (!this.isContinuous()) {
            throw new IllegalStateException("Not a continuous data set.");
        }
        DenseDoubleMatrix2D cov = new DenseDoubleMatrix2D(this.dataBox.numCols(), this.dataBox.numCols());
        double[] x = new double[this.dataBox.numRows()];
        double[] y = new double[this.dataBox.numRows()];
        for (int i = 0; i < this.dataBox.numCols(); ++i) {
            for (int j = 0; j < this.dataBox.numCols(); ++j) {
                for (int k = 0; k < this.dataBox.numRows(); ++k) {
                    x[k] = this.dataBox.get(k, i).doubleValue();
                    y[k] = this.dataBox.get(k, j).doubleValue();
                    cov.set(i, j, StatUtils.covariance(x, y));
                }
            }
        }
        return cov;
    }

    @Override
    public final int getInt(int row, int column) {
        Number value = this.dataBox.get(row, column);
        if (value == null) {
            return -99;
        }
        return value.intValue();
    }

    @Override
    public final double getDouble(int row, int column) {
        Number value = this.dataBox.get(row, column);
        if (value == null) {
            return ContinuousVariable.getDoubleMissingValue();
        }
        return value.doubleValue();
    }

    @Override
    public final void setMultiplier(int caseNumber, int multiplier) {
        if (caseNumber < 0) {
            throw new IllegalArgumentException("Case numbers must be >= 0: " + caseNumber);
        }
        if (multiplier < 0) {
            throw new IllegalArgumentException("Multipliers must be >= 0: " + multiplier);
        }
        if (multiplier == 1) {
            this.getMultipliers().remove(caseNumber);
        } else {
            this.getMultipliers().put(caseNumber, multiplier);
        }
    }

    @Override
    public final String toString() {
        int i;
        StringBuilder buf = new StringBuilder();
        List<Node> variables = this.getVariables();
        buf.append("\n");
        for (i = 0; i < this.getNumColumns(); ++i) {
            buf.append(variables.get(i));
            if (i >= this.getNumColumns() - 1) continue;
            buf.append(this.outputDelimiter);
        }
        buf.append("\n");
        for (i = 0; i < this.getNumRows(); ++i) {
            for (int j = 0; j < this.getNumColumns(); ++j) {
                Node variable = this.getVariable(j);
                if (variable instanceof ContinuousVariable) {
                    if (Double.isNaN(this.getDouble(i, j))) {
                        buf.append("*");
                    } else {
                        buf.append(this.getNumberFormat().format(this.getDouble(i, j)));
                    }
                    if (j >= this.getNumColumns() - 1) continue;
                    buf.append(this.outputDelimiter);
                    continue;
                }
                if (variable instanceof DiscreteVariable) {
                    DiscreteVariable _variable = (DiscreteVariable)variable;
                    int value = this.getInt(i, j);
                    if (value == -99) {
                        buf.append("*");
                    } else {
                        String category = _variable.getCategory(value);
                        if (category.indexOf(this.outputDelimiter) == -1) {
                            buf.append(category);
                        } else {
                            buf.append("\"" + category + "\"");
                        }
                    }
                    if (j >= this.getNumColumns() - 1) continue;
                    buf.append(this.outputDelimiter);
                    continue;
                }
                throw new IllegalStateException("Expecting either a continuous variable or a discrete variable.");
            }
            buf.append("\n");
        }
        buf.append("\n");
        if (this.knowledge != null && !this.knowledge.isEmpty()) {
            buf.append(this.knowledge);
        }
        return buf.toString();
    }

    @Override
    public final DoubleMatrix2D getDoubleData() {
        DenseDoubleMatrix2D copy = new DenseDoubleMatrix2D(this.dataBox.numRows(), this.dataBox.numCols());
        for (int i = 0; i < this.dataBox.numRows(); ++i) {
            for (int j = 0; j < this.dataBox.numCols(); ++j) {
                copy.set(i, j, this.dataBox.get(i, j).doubleValue());
            }
        }
        return copy;
    }

    @Override
    public final DataSet subsetColumns(int[] indices) {
        List<Node> variables = this.getVariables();
        LinkedList<Node> _variables = new LinkedList<Node>();
        for (int index : indices) {
            _variables.add(variables.get(index));
        }
        int[] rows = new int[this.dataBox.numRows()];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = i;
        }
        DataBox _data = this.viewSelection(rows, indices);
        BoxDataSet _dataSet = new BoxDataSet(_data, _variables);
        _dataSet.name = this.name + "_copy";
        _dataSet.variables = _variables;
        _dataSet.selection = new HashSet<Node>();
        _dataSet.multipliers = new HashMap<Integer, Integer>(this.multipliers);
        _dataSet.knowledge = new Knowledge(this.knowledge);
        return _dataSet;
    }

    @Override
    public final DataSet subsetRows(int[] rows) {
        int[] cols = new int[this.dataBox.numCols()];
        for (int i = 0; i < cols.length; ++i) {
            cols[i] = i;
        }
        BoxDataSet _data = new BoxDataSet(this);
        _data.dataBox = this.dataBox.like(rows.length, cols.length);
        for (int i = 0; i < rows.length; ++i) {
            for (int j = 0; j < cols.length; ++j) {
                _data.dataBox.set(i, j, this.dataBox.get(rows[i], cols[j]));
            }
        }
        return _data;
    }

    @Override
    public final void shiftColumnDown(int row, int col, int numRowsShifted) {
        int i;
        if (row >= this.getNumRows() || col >= this.getNumColumns()) {
            throw new IllegalArgumentException("Out of range:  row = " + row + " col = " + col);
        }
        int lastRow = -1;
        for (i = this.getNumRows() - 1; i >= row; --i) {
            if (this.dataBox.get(i, col) == null) continue;
            lastRow = i;
            break;
        }
        if (lastRow == -1) {
            return;
        }
        this.resize(this.getNumRows() + numRowsShifted, this.getNumColumns());
        for (i = this.getNumRows() - 1; i >= row + numRowsShifted; --i) {
            this.dataBox.set(i, col, this.dataBox.get(i - numRowsShifted, col));
            this.dataBox.set(i - numRowsShifted, col, null);
        }
    }

    @Override
    public final void removeCols(int[] cols) {
        int[] rows = new int[this.dataBox.numRows()];
        for (int i = 0; i < this.dataBox.numRows(); ++i) {
            rows[i] = i;
        }
        int[] retainedCols = new int[this.variables.size() - cols.length];
        int i = -1;
        for (int j = 0; j < this.variables.size(); ++j) {
            if (Arrays.binarySearch(cols, j) >= 0) continue;
            retainedCols[++i] = j;
        }
        LinkedList<Node> retainedVars = new LinkedList<Node>();
        for (int retainedCol : retainedCols) {
            retainedVars.add(this.variables.get(retainedCol));
        }
        this.dataBox = this.viewSelection(rows, cols);
        this.variables = retainedVars;
        this.selection = new HashSet<Node>();
        this.multipliers = new HashMap<Integer, Integer>(this.multipliers);
        this.knowledge = new Knowledge(this.knowledge);
    }

    @Override
    public final void removeRows(int[] selectedRows) {
        int[] cols = new int[this.dataBox.numCols()];
        for (int i = 0; i < this.dataBox.numCols(); ++i) {
            cols[i] = i;
        }
        int[] retainedRows = new int[this.dataBox.numRows() - selectedRows.length];
        int i = -1;
        for (int j = 0; j < this.dataBox.numRows(); ++j) {
            if (Arrays.binarySearch(selectedRows, j) >= 0) continue;
            retainedRows[++i] = j;
        }
        this.dataBox = this.viewSelection(retainedRows, cols);
        this.selection = new HashSet<Node>();
        this.multipliers = new HashMap<Integer, Integer>(this.multipliers);
        this.knowledge = new Knowledge(this.knowledge);
    }

    public final boolean equals(Object obj) {
        int i;
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DataSet)) {
            return false;
        }
        DataSet _dataSet = (DataSet)obj;
        for (i = 0; i < this.getVariables().size(); ++i) {
            Node _node;
            Node node = this.getVariables().get(i);
            if (((Object)node).equals(_node = _dataSet.getVariables().get(i))) continue;
            return false;
        }
        if (_dataSet.getNumRows() != this.getNumRows()) {
            return false;
        }
        for (i = 0; i < this.getNumRows(); ++i) {
            for (int j = 0; j < this.getNumColumns(); ++j) {
                double _value;
                double value;
                Node variable = this.getVariable(j);
                if (!(variable instanceof ContinuousVariable ? Math.abs((value = Double.parseDouble(nf.format(this.getDouble(i, j)))) - (_value = Double.parseDouble(nf.format(_dataSet.getDouble(i, j))))) > 0.0 : (value = (double)this.getInt(i, j)) != (_value = (double)_dataSet.getInt(i, j)))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isNewCategoriesAccomodated() {
        return this.newCategoriesAccomodated;
    }

    @Override
    public final void setNewCategoriesAccomodated(boolean newCategoriesAccomodated) {
        this.newCategoriesAccomodated = newCategoriesAccomodated;
    }

    @Override
    public void setNumberFormat(NumberFormat nf) {
        if (nf == null) {
            throw new NullPointerException();
        }
        this.nf = nf;
    }

    @Override
    public void setOutputDelimiter(Character character) {
        this.outputDelimiter = character.charValue();
    }

    @Override
    public void permuteRows() {
        ArrayList<Integer> permutation = new ArrayList<Integer>();
        for (int i = 0; i < this.getNumRows(); ++i) {
            permutation.add(i);
        }
        Collections.shuffle(permutation);
        DataBox data2 = this.dataBox.like(this.dataBox.numRows(), this.dataBox.numCols());
        for (int i = 0; i < this.getNumRows(); ++i) {
            for (int j = 0; j < this.getNumColumns(); ++j) {
                data2.set(i, j, this.dataBox.get((Integer)permutation.get(i), j));
            }
        }
        this.dataBox = data2;
    }

    private void setIntPrivate(int row, int col, int value) {
        if (value == -99) {
            this.dataBox.set(row, col, null);
        } else {
            this.dataBox.set(row, col, value);
        }
    }

    private void resize(int rows, int cols) {
        DataBox _data = this.dataBox.like(rows, cols);
        for (int i = 0; i < _data.numRows(); ++i) {
            for (int j = 0; j < _data.numCols(); ++j) {
                if (i < this.dataBox.numRows() && j < this.dataBox.numCols()) {
                    _data.set(i, j, this.dataBox.get(i, j));
                    continue;
                }
                _data.set(i, j, null);
            }
        }
        this.dataBox = _data;
    }

    private Map<Integer, Integer> getMultipliers() {
        return this.multipliers;
    }

    private static void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    private Set<Node> getSelection() {
        if (this.selection == null) {
            this.selection = new HashSet<Node>();
        }
        return this.selection;
    }

    private static double getValueFromObjectContinuous(Object element) {
        if ("*".equals(element) || "".equals(element)) {
            return ContinuousVariable.getDoubleMissingValue();
        }
        if (element instanceof Number) {
            return ((Number)element).doubleValue();
        }
        if (element instanceof String) {
            try {
                return Double.parseDouble((String)element);
            }
            catch (NumberFormatException e) {
                return ContinuousVariable.getDoubleMissingValue();
            }
        }
        throw new IllegalArgumentException("The argument 'element' must be either a Number or a String.");
    }

    private int getValueFromObjectDiscrete(Object element, DiscreteVariable variable) {
        if ("*".equals(element) || "".equals(element)) {
            return -99;
        }
        if (variable.isAccommodateNewCategories()) {
            if (element instanceof Number) {
                int index = ((Number)element).intValue();
                if (!variable.checkValue(index)) {
                    if (index >= variable.getNumCategories()) {
                        this.accomodateIndex(variable, index);
                    } else {
                        throw new IllegalArgumentException("Variable " + variable + " is not accepting " + "new categories. Problem category is " + ".");
                    }
                }
                return index;
            }
            if (element instanceof String) {
                String label = (String)element;
                if ("".equals(label)) {
                    throw new IllegalArgumentException("Blank category names not permitted.");
                }
                int index = (variable = this.accomodateCategory(variable, label)).getIndex(label);
                if (index == -1) {
                    throw new IllegalArgumentException("Not a category for this variable: " + index);
                }
                return index;
            }
            throw new IllegalArgumentException("The argument 'element' must be either a Number or a String.");
        }
        if (element instanceof Number) {
            int index = ((Number)element).intValue();
            if (!variable.checkValue(index)) {
                return -99;
            }
            return index;
        }
        if (element instanceof String) {
            String label = (String)element;
            int index = variable.getIndex(label);
            if (index == -1) {
                return -99;
            }
            return index;
        }
        throw new IllegalArgumentException("The argument 'element' must be either a Number or a String.");
    }

    private DiscreteVariable accomodateCategory(DiscreteVariable variable, String category) {
        if (category == null) {
            throw new NullPointerException();
        }
        List<String> categories = variable.getCategories();
        if (!categories.contains(category)) {
            LinkedList<String> newCategories = new LinkedList<String>(categories);
            newCategories.add(category);
            DiscreteVariable newVariable = new DiscreteVariable(variable.getName(), newCategories);
            this.changeVariable(variable, newVariable);
            return newVariable;
        }
        return variable;
    }

    private void accomodateIndex(DiscreteVariable variable, int index) {
        if (!variable.isAccommodateNewCategories()) {
            throw new IllegalArgumentException("This variable is not set to accomodate new categories.");
        }
        if (index >= variable.getNumCategories()) {
            this.adjustCategories(variable, index + 1);
        }
    }

    private void adjustCategories(DiscreteVariable variable, int numCategories) {
        int i;
        LinkedList<String> categories = new LinkedList<String>(variable.getCategories());
        LinkedList<String> newCategories = new LinkedList<String>(categories);
        if (categories.size() > numCategories) {
            for (i = variable.getCategories().size() - 1; i >= numCategories; ++i) {
                newCategories.remove(i);
            }
        } else if (categories.size() < numCategories) {
            for (i = categories.size(); i < numCategories; ++i) {
                String category = DataUtils.defaultCategory(i);
                if (categories.contains(category)) continue;
                newCategories.add(category);
            }
        }
        DiscreteVariable to = new DiscreteVariable(variable.getName(), newCategories);
        this.changeVariable(variable, to);
    }

    private NumberFormat getNumberFormat() {
        if (this.nf == null) {
            this.nf = NumberFormatUtil.getInstance().getNumberFormat();
        }
        return this.nf;
    }
}

