/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataFilter;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;

public final class CaseExpander
implements DataFilter {
    @Override
    public final DataSet filter(DataSet dataSet) {
        return CaseExpander.expand(dataSet);
    }

    private static DataSet expand(DataSet dataSet) {
        int rows = 0;
        for (int i = 0; i < dataSet.getNumRows(); ++i) {
            int caseMultiplier = dataSet.getMultiplier(i);
            for (int k = 0; k < caseMultiplier; ++k) {
                ++rows;
            }
        }
        ColtDataSet newDataSet = new ColtDataSet(rows, dataSet.getVariables());
        int cols = dataSet.getNumColumns();
        int index = -1;
        for (int i = 0; i < dataSet.getNumRows(); ++i) {
            int caseMultiplier = dataSet.getMultiplier(i);
            for (int k = 0; k < caseMultiplier; ++k) {
                ++index;
                for (int j = 0; j < cols; ++j) {
                    if (dataSet.getVariable(j) instanceof ContinuousVariable) {
                        newDataSet.setDouble(index, j, dataSet.getDouble(i, j));
                        continue;
                    }
                    if (dataSet.getVariable(j) instanceof DiscreteVariable) {
                        newDataSet.setInt(index, j, dataSet.getInt(i, j));
                        continue;
                    }
                    throw new IllegalStateException("Expecting either a continuous or a discrete variable.");
                }
            }
        }
        return newDataSet;
    }
}

