/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.util.TetradSerializable;
import java.io.ObjectStreamException;
import java.util.regex.Pattern;

public final class DelimiterType
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    public static final DelimiterType WHITESPACE = new DelimiterType("Whitespace", "\\s+");
    public static final DelimiterType TAB = new DelimiterType("Tab", "\t");
    public static final DelimiterType COMMA = new DelimiterType("Comma", ",");
    public static final DelimiterType COLON = new DelimiterType("Comma", ":");
    public static final DelimiterType WHITESPACE_OR_COMMA = new DelimiterType("Comma", " *[\\t ,] *");
    private final transient String name;
    private final transient Pattern pattern;
    private static int nextOrdinal = 0;
    private final int ordinal = nextOrdinal++;
    private static final DelimiterType[] TYPES = new DelimiterType[]{WHITESPACE, TAB, COMMA};

    private DelimiterType(String name, String regex) {
        this.name = name;
        this.pattern = Pattern.compile(regex);
    }

    public static DelimiterType serializableInstance() {
        return TAB;
    }

    public final Pattern getPattern() {
        return this.pattern;
    }

    public final String toString() {
        return this.name;
    }

    final Object readResolve() throws ObjectStreamException {
        return TYPES[this.ordinal];
    }
}

