/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.AbstractVariable;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.DiscreteVariableType;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.util.TetradSerializable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public final class DiscreteVariable
extends AbstractVariable
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    public static final int MISSING_VALUE = -99;
    private static final String MISSING_VALUE_STRING = "*";
    private static List<LinkedList<String>> STORED_CATEGORY_LISTS = null;
    private transient List<String> categories = null;
    private List<String> categoriesCopy = new ArrayList<String>();
    private final DiscreteVariableType discreteVariableType = DiscreteVariableType.NOMINAL;
    private boolean categoryNamesDisplayed = true;
    private NodeType nodeType = NodeType.MEASURED;
    private boolean accommodateNewCategories = true;
    private int centerX = -1;
    private int centerY = -1;
    private transient PropertyChangeSupport pcs;

    public DiscreteVariable(String name) {
        super(name);
    }

    public DiscreteVariable(String name, int numCategories) {
        super(name);
        this.setCategories(numCategories);
        this.setCategoryNamesDisplayed(false);
    }

    public DiscreteVariable(String name, List<String> categories) {
        super(name);
        this.setCategories(categories.toArray(new String[0]));
        this.setCategoryNamesDisplayed(true);
    }

    public DiscreteVariable(DiscreteVariable variable) {
        super(variable.getName());
        this.categoriesCopy = DiscreteVariable.getStoredCategoryList(variable.getCategories());
        this.setCategoryNamesDisplayed(true);
    }

    public static DiscreteVariable serializableInstance() {
        return new DiscreteVariable("X");
    }

    public final DiscreteVariableType getDiscreteVariableType() {
        return this.discreteVariableType;
    }

    public final int getIndex(String category) {
        return this.getCategories().indexOf(category);
    }

    public final int getNumCategories() {
        return this.getCategories().size();
    }

    @Override
    public final Object getMissingValueMarker() {
        return -99;
    }

    public final String getCategory(int category) {
        if (category == -99) {
            return MISSING_VALUE_STRING;
        }
        return this.getCategories().get(category);
    }

    public final List<String> getCategories() {
        if (this.categories == null) {
            this.categories = DiscreteVariable.getStoredCategoryList(this.categoriesCopy);
        }
        return new LinkedList<String>(this.categories);
    }

    public final boolean checkValue(int category) {
        boolean inRange = category >= 0 && category < this.getNumCategories();
        boolean isMissing = category == -99;
        return inRange || isMissing;
    }

    public final boolean checkValue(String value) {
        return this.getCategories().contains(value);
    }

    @Override
    public final boolean isMissingValue(Object value) {
        if (value instanceof Integer) {
            Integer ivalue = (Integer)value;
            return ivalue == -99;
        }
        if (value instanceof String) {
            return MISSING_VALUE_STRING.equals(value);
        }
        return false;
    }

    public final boolean isCategoryNamesDisplayed() {
        return this.categoryNamesDisplayed;
    }

    public final void setCategoryNamesDisplayed(boolean categoryNamesDisplayed) {
        this.categoryNamesDisplayed = categoryNamesDisplayed;
    }

    @Override
    public final int hashCode() {
        int hashCode = 39;
        hashCode = 17 * hashCode + this.getName().hashCode();
        for (int i = 0; i < this.getNumCategories(); ++i) {
            hashCode = 17 * hashCode + this.getCategory(i).hashCode();
        }
        hashCode = 17 * hashCode + this.getNodeType().hashCode();
        return hashCode;
    }

    @Override
    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof DiscreteVariable)) {
            return false;
        }
        DiscreteVariable variable = (DiscreteVariable)o;
        if (!this.getName().equals(variable.getName())) {
            return false;
        }
        if (this.getNumCategories() != variable.getNumCategories()) {
            return false;
        }
        for (int i = 0; i < this.getNumCategories(); ++i) {
            if (this.getCategory(i).equals(variable.getCategory(i))) continue;
            return false;
        }
        return this.getNodeType() == variable.getNodeType();
    }

    @Override
    public final NodeType getNodeType() {
        return this.nodeType;
    }

    @Override
    public final void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public boolean isAccommodateNewCategories() {
        return this.accommodateNewCategories;
    }

    public void setAccommodateNewCategories(boolean accommodateNewCategories) {
        this.accommodateNewCategories = accommodateNewCategories;
    }

    @Override
    public final int getCenterX() {
        return this.centerX;
    }

    @Override
    public final void setCenterX(int centerX) {
        this.centerX = centerX;
    }

    @Override
    public final int getCenterY() {
        return this.centerY;
    }

    @Override
    public final void setCenterY(int centerY) {
        this.centerY = centerY;
    }

    @Override
    public final void setCenter(int centerX, int centerY) {
        this.centerX = centerX;
        this.centerY = centerY;
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().addPropertyChangeListener(l);
    }

    @Override
    public final String toString() {
        return this.getName();
    }

    public final String toStringFull() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getName());
        buf.append(" <");
        for (int i = 0; i < this.getNumCategories(); ++i) {
            buf.append(this.getCategory(i));
            if (i >= this.getNumCategories() - 1) continue;
            buf.append(", ");
        }
        buf.append(">");
        return buf.toString();
    }

    private void setCategories(String[] categories) {
        for (String category : categories) {
            if (category != null) continue;
            throw new NullPointerException();
        }
        List<String> categoryList = Arrays.asList(categories);
        if (new HashSet<String>(categoryList).size() != categoryList.size()) {
            throw new IllegalArgumentException("Duplicate category.");
        }
        this.categoriesCopy = DiscreteVariable.getStoredCategoryList(categoryList);
    }

    private void setCategories(int numCategories) {
        String[] categories = new String[numCategories];
        for (int i = 0; i < numCategories; ++i) {
            categories[i] = DataUtils.defaultCategory(i);
        }
        this.setCategories(categories);
    }

    private PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    private static List<String> getStoredCategoryList(List<String> categoryList) {
        if (categoryList == null) {
            throw new NullPointerException();
        }
        HashSet<String> categorySet = new HashSet<String>(categoryList);
        if (STORED_CATEGORY_LISTS == null) {
            STORED_CATEGORY_LISTS = new ArrayList<LinkedList<String>>();
        }
        for (LinkedList<String> list : STORED_CATEGORY_LISTS) {
            if (!((Object)categorySet).equals(new HashSet<String>(list))) continue;
            return list;
        }
        LinkedList<String> newList = new LinkedList<String>(categoryList);
        STORED_CATEGORY_LISTS.add(newList);
        return newList;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.categoriesCopy == null) {
            throw new NullPointerException();
        }
        if (this.discreteVariableType == null) {
            throw new NullPointerException();
        }
        if (this.nodeType == null) {
            throw new NullPointerException();
        }
    }
}

