/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousDiscretizationSpec;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Discretizer {
    private DataSet sourceDataSet;
    Map<Node, ContinuousDiscretizationSpec> specs;
    private boolean variablesCopied = true;

    public Discretizer(DataSet dataSet) {
        this.sourceDataSet = dataSet;
        this.specs = new HashMap<Node, ContinuousDiscretizationSpec>();
    }

    public Discretizer(DataSet dataSet, Map<Node, ContinuousDiscretizationSpec> specs) {
        this.sourceDataSet = dataSet;
        this.specs = specs;
    }

    public void equalCounts(Node node, int numCategories) {
        String name = node.getName();
        int i = this.sourceDataSet.getVariables().indexOf(node);
        double[] data = this.sourceDataSet.getDoubleData().viewColumn(i).toArray();
        double[] breakpoints = Discretizer.getEqualFrequencyBreakPoints(data, numCategories);
        List<String> categories = new DiscreteVariable(name, numCategories).getCategories();
        ContinuousDiscretizationSpec spec = new ContinuousDiscretizationSpec(breakpoints, categories);
        spec.setMethod(1);
        this.specs.put(node, spec);
    }

    public void equalIntervals(Node node, int numCategories) {
        String name = node.getName();
        int i = this.sourceDataSet.getVariables().indexOf(node);
        double[] data = this.sourceDataSet.getDoubleData().viewColumn(i).toArray();
        double[] breakpoints = Discretizer.getEqualFrequencyBreakPoints(data, numCategories);
        List<String> categories = new DiscreteVariable(name, numCategories).getCategories();
        ContinuousDiscretizationSpec spec = new ContinuousDiscretizationSpec(breakpoints, categories);
        spec.setMethod(2);
        this.specs.put(node, spec);
    }

    public void notDiscretized(Node node) {
        this.specs.remove(node);
    }

    public void setVariablesCopied(boolean unselectedVariabledCopied) {
        this.variablesCopied = unselectedVariabledCopied;
    }

    public boolean isVariablesCopied() {
        return this.variablesCopied;
    }

    public DataSet discretize() {
        LinkedList<Node> variables = new LinkedList<Node>();
        HashMap<DiscreteVariable, Node> replacementMapping = new HashMap<DiscreteVariable, Node>();
        for (int i = 0; i < this.sourceDataSet.getNumColumns(); ++i) {
            Node variable = this.sourceDataSet.getVariable(i);
            if (variable instanceof ContinuousVariable) {
                ContinuousDiscretizationSpec spec = this.specs.get(variable);
                if (spec != null) {
                    List<String> cats = spec.getCategories();
                    DiscreteVariable var = new DiscreteVariable(variable.getName(), cats);
                    replacementMapping.put(var, variable);
                    variables.add(var);
                    continue;
                }
                if (!this.isVariablesCopied()) continue;
                variables.add(variable);
                continue;
            }
            if (!this.isVariablesCopied()) continue;
            variables.add(variable);
        }
        ColtDataSet newDataSet = new ColtDataSet(this.sourceDataSet.getNumRows(), variables);
        for (int i = 0; i < newDataSet.getNumColumns(); ++i) {
            Node variable = newDataSet.getVariable(i);
            Node sourceVar = (Node)replacementMapping.get(variable);
            if (sourceVar != null && this.specs.containsKey(sourceVar)) {
                ContinuousDiscretizationSpec spec = this.specs.get(sourceVar);
                double[] breakpoints = spec.getBreakpoints();
                List<String> categories = spec.getCategories();
                String name = variable.getName();
                double[] trimmedData = new double[newDataSet.getNumRows()];
                int col = newDataSet.getColumn(variable);
                for (int j = 0; j < this.sourceDataSet.getNumRows(); ++j) {
                    trimmedData[j] = this.sourceDataSet.getDouble(j, col);
                }
                Discretization discretization = Discretizer.discretize(trimmedData, breakpoints, name, categories);
                int _col = newDataSet.getColumn(variable);
                int[] _data = discretization.getData();
                for (int j = 0; j < _data.length; ++j) {
                    newDataSet.setInt(j, _col, _data[j]);
                }
                continue;
            }
            DataUtils.copyColumn(variable, this.sourceDataSet, newDataSet);
        }
        return newDataSet;
    }

    public static double[] getEqualFrequencyBreakPoints(double[] _data, int numberOfCategories) {
        double[] data = new double[_data.length];
        System.arraycopy(_data, 0, data, 0, data.length);
        Arrays.sort(data);
        ArrayList<Chunk> chunks = new ArrayList<Chunk>(data.length);
        int startChunkCount = 0;
        double lastValue = data[0];
        for (int i = 0; i < data.length; ++i) {
            double value = data[i];
            if (value != lastValue) {
                chunks.add(new Chunk(startChunkCount, i, value));
                startChunkCount = i;
            }
            lastValue = value;
        }
        chunks.add(new Chunk(startChunkCount, data.length, data[data.length - 1]));
        double interval = data.length / numberOfCategories;
        double[] breakpoints = new double[numberOfCategories - 1];
        int current = 0;
        int freq = 0;
        for (Chunk chunk : chunks) {
            int valuesInChunk = chunk.getNumberOfValuesInChunk();
            int halfChunk = (int)((double)valuesInChunk * 0.5);
            freq = (double)(freq + halfChunk) <= interval ? (freq += valuesInChunk) : valuesInChunk;
            if (!(interval <= (double)freq)) continue;
            freq = 0;
            if (current >= breakpoints.length) continue;
            breakpoints[current++] = chunk.value;
        }
        for (int i = current; i < breakpoints.length; ++i) {
            breakpoints[i] = Double.POSITIVE_INFINITY;
        }
        double[] _breakpoints = new double[current];
        System.arraycopy(breakpoints, 0, _breakpoints, 0, current);
        return breakpoints;
    }

    public static Discretization discretize(double[] _data, double[] cutoffs, String variableName, List<String> categories) {
        if (cutoffs == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < cutoffs.length - 1; ++i) {
            if (cutoffs[i] <= cutoffs[i + 1]) continue;
            throw new NullPointerException("Cutoffs must be in nondecreasing order.");
        }
        if (variableName == null) {
            throw new NullPointerException();
        }
        int numCategories = cutoffs.length + 1;
        if (categories != null && categories.size() != numCategories) {
            throw new IllegalArgumentException("If specified, the list of categories names must be one longer than the length of the cutoffs array.");
        }
        DiscreteVariable variable = categories == null ? new DiscreteVariable(variableName, numCategories) : new DiscreteVariable(variableName, categories);
        int[] discreteData = new int[_data.length];
        block1: for (int i = 0; i < _data.length; ++i) {
            for (int j = 0; j < cutoffs.length; ++j) {
                if (!(_data[i] > Double.NEGATIVE_INFINITY) || !(_data[i] < Double.POSITIVE_INFINITY) || !(_data[i] < cutoffs[j])) continue;
                discreteData[i] = j;
                continue block1;
            }
            discreteData[i] = cutoffs.length;
        }
        return new Discretization(variable, discreteData);
    }

    private static class Chunk {
        private int valuesInChunk;
        private double value;

        public Chunk(int low, int high, double value) {
            this.valuesInChunk = high - low;
            this.value = value;
        }

        public int getNumberOfValuesInChunk() {
            return this.valuesInChunk;
        }
    }

    public static class Discretization {
        private final DiscreteVariable variable;
        private final int[] data;

        private Discretization(DiscreteVariable variable, int[] data) {
            this.variable = variable;
            this.data = data;
        }

        public final DiscreteVariable getVariable() {
            return this.variable;
        }

        public final int[] getData() {
            return this.data;
        }

        public final String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("\n\nDiscretization:");
            for (int aData : this.data) {
                buf.append("\n").append(this.variable.getCategory(aData));
            }
            buf.append("\n");
            return buf.toString();
        }
    }
}

