/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public final class Lineizer {
    private final BufferedReader reader;
    private String tempLine = null;
    private String commentMarker;
    private int lineNumber = 0;

    public Lineizer(Reader reader, String commentMarker) {
        if (reader == null) {
            throw new NullPointerException();
        }
        if (commentMarker == null) {
            throw new NullPointerException();
        }
        this.reader = new BufferedReader(reader);
        this.commentMarker = commentMarker;
    }

    public final boolean hasMoreLines() {
        if (this.tempLine == null) {
            try {
                this.tempLine = this.readLine();
                return this.tempLine != null;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public final String nextLine() {
        ++this.lineNumber;
        if (this.tempLine == null) {
            try {
                return this.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        String line = this.tempLine;
        this.tempLine = null;
        return line;
    }

    private String readLine() throws IOException {
        String line;
        while ((line = this.reader.readLine()) != null) {
            if ("".equals(line) || line.startsWith(this.commentMarker)) continue;
            return line;
        }
        return null;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

