/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataBox;
import edu.cmu.tetrad.data.ShortDataBox;

public class LongDataBox
implements DataBox {
    static final long serialVersionUID = 23L;
    private long[][] data;

    public LongDataBox(int rows, int cols) {
        this.data = new long[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                this.data[i][j] = -99L;
            }
        }
    }

    public LongDataBox(long[][] data) {
        int length = data[0].length;
        for (long[] datum : data) {
            if (datum.length == length) continue;
            throw new IllegalArgumentException("All rows must have same length.");
        }
        this.data = data;
    }

    public static BoxDataSet serializableInstance() {
        return new BoxDataSet(new ShortDataBox(4, 4), null);
    }

    @Override
    public int numRows() {
        return this.data.length;
    }

    @Override
    public int numCols() {
        return this.data[0].length;
    }

    @Override
    public void set(int row, int col, Number value) {
        this.data[row][col] = value == null ? -99L : value.longValue();
    }

    @Override
    public Number get(int row, int col) {
        long datum = this.data[row][col];
        if (datum == -99L) {
            return null;
        }
        return datum;
    }

    @Override
    public DataBox copy() {
        LongDataBox box = new LongDataBox(this.numRows(), this.numCols());
        for (int i = 0; i < this.numRows(); ++i) {
            for (int j = 0; j < this.numCols(); ++j) {
                box.set(i, j, this.get(i, j));
            }
        }
        return box;
    }

    @Override
    public DataBox like(int rows, int cols) {
        return new LongDataBox(rows, cols);
    }
}

