/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.Node;
import java.util.LinkedList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestCovarianceMatrix
extends TestCase {
    private final double[][] data = new double[][]{{-0.377133, -1.480267, -1.696021, 1.195592, -0.345426}, {-0.694507, -2.568514, -4.654334, 0.094623, -6.081831}, {1.819202, 0.693551, 4.62622, 1.228998, 8.082}, {-0.131759, -0.256599, -1.319799, 0.304622, -2.588121}, {-1.407105, -1.455764, -2.185402, -3.848737, -4.357246}, {-1.099269, -1.892556, -1.63933, -1.156234, -4.174009}, {-0.27342, -0.079434, 0.226354, 0.919383, 1.151157}, {0.358854, -0.982877, 0.89074, 1.85012, 1.504533}, {-0.407574, -0.3164, -1.423396, 0.991819, -0.956139}, {1.243824, 1.690462, 4.045195, 1.34646, 5.247904}};

    public TestCovarianceMatrix(String name) {
        super(name);
    }

    public void testConstruction() {
        LinkedList<Node> variables = new LinkedList<Node>();
        for (int i = 0; i < 5; ++i) {
            ContinuousVariable var = new ContinuousVariable("X" + i);
            variables.add(var);
        }
        ColtDataSet dataSet = new ColtDataSet(10, variables);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 5; ++j) {
                dataSet.setDouble(i, j, this.data[i][j]);
            }
        }
        System.out.println(dataSet);
        CovarianceMatrix covMatrix = new CovarianceMatrix(dataSet);
        System.out.println("covMatrix = " + covMatrix);
        CorrelationMatrix corrMatrix = new CorrelationMatrix(covMatrix);
        System.out.println("corrMatrix = " + corrMatrix);
        CorrelationMatrix corrMatrix2 = new CorrelationMatrix(dataSet);
        System.out.println("corrMatrix2 = " + corrMatrix2);
        System.out.println("covMatrix = " + covMatrix);
    }

    public static void testPositiveDefinite() {
        String[] varNames = new String[]{"X1", "X2", "X3"};
        double[][] mUpper = new double[][]{{1.0}, {0.3, 1.0}, {0.8, -0.2, 1.0}};
        DenseDoubleMatrix2D m = new DenseDoubleMatrix2D(mUpper.length, mUpper.length);
        for (int i = 0; i < mUpper.length; ++i) {
            for (int j = 0; j < mUpper.length; ++j) {
                if (j <= i) {
                    m.set(i, j, mUpper[i][j]);
                    continue;
                }
                m.set(i, j, mUpper[j][i]);
            }
        }
        new CovarianceMatrix(DataUtils.createContinuousVariables(varNames), m, 30);
    }

    public static void testEditing() {
    }

    public static Test suite() {
        return new TestSuite(TestCovarianceMatrix.class);
    }
}

