/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DelimiterType;
import edu.cmu.tetrad.util.TetradLogger;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestDataReader
extends TestCase {
    public TestDataReader(String name) {
        super(name);
    }

    public void test1() {
        TetradLogger.getInstance().addOutputStream(System.out);
        File file = new File("sample_data/cheese.txt");
        char[] chars = this.fileToCharArray(file);
        DataReader reader = new DataReader();
        reader.setDelimiter(DelimiterType.WHITESPACE);
        reader.setIdsSupplied(true);
        reader.setIdLabel("Case");
        DataSet data = reader.parseTabular(chars);
        TetradLogger.getInstance().removeOutputStream(System.out);
        System.out.println(data);
    }

    public void test1b() {
        TetradLogger.getInstance().addOutputStream(System.out);
        File file = new File("sample_data/cheese2.txt");
        char[] chars = this.fileToCharArray(file);
        DataReader reader = new DataReader();
        reader.setDelimiter(DelimiterType.WHITESPACE);
        reader.setVariablesSupplied(false);
        reader.setIdsSupplied(true);
        reader.setIdLabel(null);
        DataSet data = reader.parseTabular(chars);
        TetradLogger.getInstance().removeOutputStream(System.out);
        System.out.println(data);
    }

    public void test11() {
        try {
            DataReader reader = new DataReader();
            reader.parseTabular(new File("test_data/roi_file_1_5.txt"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void test10() {
        TetradLogger.getInstance().addOutputStream(System.out);
        File file = new File("sample_data/bollen.txt");
        char[] chars = this.fileToCharArray(file);
        DataReader reader = new DataReader();
        DataSet data = reader.parseTabular(chars);
        TetradLogger.getInstance().removeOutputStream(System.out);
        System.out.println(data);
    }

    private char[] fileToCharArray(File file) {
        try {
            int c;
            FileReader reader = new FileReader(file);
            CharArrayWriter writer = new CharArrayWriter();
            while ((c = reader.read()) != -1) {
                writer.write(c);
            }
            return writer.toCharArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Test suite() {
        return new TestSuite(TestDataReader.class);
    }
}

