/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.data;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Node;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class TimeSeriesData
implements DataModel {
    static final long serialVersionUID = 23L;
    private DoubleMatrix2D data2;
    private double[][] data;
    private String name;
    private List<String> varNames;
    private Knowledge knowledge = new Knowledge();

    public TimeSeriesData(DoubleMatrix2D matrix, List<String> varNames) {
        if (matrix == null) {
            throw new NullPointerException("Data must not be null.");
        }
        if (varNames == null) {
            throw new NullPointerException("Variables must not be null.");
        }
        for (int i = 0; i < varNames.size(); ++i) {
            if (varNames.get(i) != null) continue;
            throw new NullPointerException("Variable at index " + i + "is null.");
        }
        this.data2 = matrix;
        if (varNames.size() != matrix.columns()) {
            throw new IllegalArgumentException("Number of columns in the data must match the number of variables.");
        }
        this.varNames = varNames;
        this.name = "Time Series Data";
    }

    public static TimeSeriesData serializableInstance() {
        ArrayList<String> varNames = new ArrayList<String>();
        varNames.add("X");
        varNames.add("Y");
        return new TimeSeriesData(new DenseDoubleMatrix2D(2, 2), varNames);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        this.name = name;
    }

    @Override
    public final List<Node> getVariables() {
        List<String> varNames = this.getVariableNames();
        LinkedList<Node> vars = new LinkedList<Node>();
        for (String varName : varNames) {
            vars.add(new ContinuousVariable(varName));
        }
        return vars;
    }

    @Override
    public final Knowledge getKnowledge() {
        return new Knowledge(this.knowledge);
    }

    @Override
    public final void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = new Knowledge(knowledge);
    }

    @Override
    public final List<String> getVariableNames() {
        return this.varNames;
    }

    public final DoubleMatrix2D getData() {
        return this.data2.copy();
    }

    public final int getNumTimePoints() {
        return this.getData().rows();
    }

    public final int getNumVars() {
        return this.getVariableNames().size();
    }

    public final double getDatum(int row, int col) {
        return this.data2.get(row, col);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.data != null) {
            this.data2 = new DenseDoubleMatrix2D(this.data);
        }
        if (this.name == null) {
            throw new NullPointerException();
        }
        if (this.varNames == null) {
            throw new NullPointerException();
        }
        if (this.knowledge == null) {
            throw new NullPointerException();
        }
    }
}

