/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConstraint;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import java.util.Collection;
import java.util.HashSet;

public final class BidirectedToExogenous
implements GraphConstraint {
    static final long serialVersionUID = 23L;

    public static BidirectedToExogenous serializableInstance() {
        return new BidirectedToExogenous();
    }

    @Override
    public boolean isEdgeAddable(Edge edge, Graph graph) {
        if (Edges.isBidirectedEdge(edge)) {
            Node nodeA = edge.getNode1();
            Node nodeB = edge.getNode2();
            return this.isExogenous(nodeA, graph) && this.isExogenous(nodeB, graph);
        }
        if (Edges.isDirectedEdge(edge)) {
            Node head = this.getDirectedEdgeHead(edge);
            for (Edge edge1 : graph.getEdges(head)) {
                if (!Edges.isBidirectedEdge(edge1)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isNodeAddable(Node node, Graph graph) {
        return true;
    }

    @Override
    public boolean isEdgeRemovable(Edge edge, Graph graph) {
        return true;
    }

    @Override
    public boolean isNodeRemovable(Node node, Graph graph) {
        return true;
    }

    private Node getDirectedEdgeHead(Edge edge) {
        if (edge.getEndpoint1() == Endpoint.ARROW) {
            return edge.getNode1();
        }
        return edge.getNode2();
    }

    private int getInDegree(Node node, Graph graph) {
        return this.getParents(node, graph).size();
    }

    private Collection<Node> getParents(Node node, Graph graph) {
        HashSet<Node> parents = new HashSet<Node>();
        for (Edge edge1 : graph.getEdges(node)) {
            Node sub = Edges.traverseReverseDirected(node, edge1);
            if (sub == null) continue;
            parents.add(sub);
        }
        return parents;
    }

    private boolean isExogenous(Node node, Graph graph) {
        boolean isError = node.getNodeType() == NodeType.ERROR;
        boolean indegreeZero = this.getInDegree(node, graph) == 0;
        return isError || indegreeZero;
    }

    @Override
    public String toString() {
        return "<Bidirected edges connect exogenous nodes.>";
    }
}

