/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConstraint;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.Pair;
import edu.cmu.tetrad.graph.Triple;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class EdgeListGraph
implements Graph {
    static final long serialVersionUID = 23L;
    private final List<Node> nodes;
    private final List<Edge> edges;
    private Map<Node, List<Edge>> edgeLists;
    private final List<GraphConstraint> graphConstraints;
    private boolean graphConstraintsChecked = true;
    private transient PropertyChangeSupport pcs;
    private Set<Triple> ambiguousTriples = new HashSet<Triple>();
    private Set<Triple> underLineTriples = new HashSet<Triple>();
    private Set<Triple> dottedUnderLineTriples = new HashSet<Triple>();
    private Set<Pair> ambiguousPairs = new HashSet<Pair>();
    private boolean stuffRemovedSinceLastTripleAccess = false;

    public EdgeListGraph() {
        this.graphConstraints = new LinkedList<GraphConstraint>();
        this.edgeLists = new HashMap<Node, List<Edge>>();
        this.nodes = new LinkedList<Node>();
        this.edges = new LinkedList<Edge>();
    }

    public EdgeListGraph(Graph graph) throws IllegalArgumentException {
        this();
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        this.transferNodesAndEdges(graph);
        this.ambiguousTriples = graph.getAmbiguousTriples();
        this.underLineTriples = graph.getUnderLines();
        this.dottedUnderLineTriples = graph.getDottedUnderlines();
    }

    public EdgeListGraph(List<Node> nodes) {
        this();
        if (nodes == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < nodes.size(); ++i) {
            if (nodes.get(i) == null) {
                throw new NullPointerException();
            }
            for (int j = 0; j < i; ++j) {
                if (!((Object)nodes.get(i)).equals(nodes.get(j))) continue;
                throw new IllegalArgumentException("Two variables by the same name: " + nodes.get(i));
            }
        }
        for (Node variable : nodes) {
            if (this.addNode(variable)) continue;
            throw new IllegalArgumentException();
        }
        GraphUtils.arrangeInCircle(this, 200, 200, 150);
    }

    public static EdgeListGraph serializableInstance() {
        return new EdgeListGraph();
    }

    @Override
    public boolean addGraphConstraint(GraphConstraint gc) {
        if (!this.graphConstraints.contains(gc)) {
            this.graphConstraints.add(gc);
            return true;
        }
        return false;
    }

    @Override
    public boolean addDirectedEdge(Node node1, Node node2) {
        return this.addEdge(Edges.directedEdge(node1, node2));
    }

    @Override
    public boolean addUndirectedEdge(Node node1, Node node2) {
        return this.addEdge(Edges.undirectedEdge(node1, node2));
    }

    @Override
    public boolean addNondirectedEdge(Node node1, Node node2) {
        return this.addEdge(Edges.nondirectedEdge(node1, node2));
    }

    @Override
    public boolean addPartiallyOrientedEdge(Node node1, Node node2) {
        return this.addEdge(Edges.partiallyOrientedEdge(node1, node2));
    }

    @Override
    public boolean addBidirectedEdge(Node node1, Node node2) {
        return this.addEdge(Edges.bidirectedEdge(node1, node2));
    }

    @Override
    public boolean existsDirectedCycle() {
        for (Node node : this.getNodes()) {
            if (!this.existsDirectedPathFromTo(node, node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDirectedFromTo(Node node1, Node node2) {
        return this.getEndpoint(node2, node1) == Endpoint.TAIL && this.getEndpoint(node1, node2) == Endpoint.ARROW;
    }

    @Override
    public boolean isUndirectedFromTo(Node node1, Node node2) {
        return this.getEndpoint(node2, node1) == Endpoint.TAIL & this.getEndpoint(node1, node2) == Endpoint.TAIL;
    }

    @Override
    public boolean defVisible(Edge edge) {
        if (this.containsEdge(edge)) {
            Node A = Edges.getDirectedEdgeTail(edge);
            Node B = Edges.getDirectedEdgeHead(edge);
            List<Node> adjToA = this.getAdjacentNodes(A);
            while (!adjToA.isEmpty()) {
                Node Curr = adjToA.remove(0);
                if (this.getAdjacentNodes(Curr).contains(B) || this.getEdge(Curr, A).getProximalEndpoint(A) != Endpoint.ARROW) continue;
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("Given edge is not in the graph.");
    }

    @Override
    public boolean isDefNoncollider(Node node1, Node node2, Node node3) {
        if (this.isDirectedFromTo(node2, node1) || this.isDirectedFromTo(node2, node3)) {
            return true;
        }
        if (!this.isAdjacentTo(node1, node3)) {
            boolean endpt1 = this.getEndpoint(node1, node2) == Endpoint.CIRCLE;
            boolean endpt2 = this.getEndpoint(node3, node2) == Endpoint.CIRCLE;
            return endpt1 && endpt2;
        }
        return false;
    }

    @Override
    public boolean isDefCollider(Node node1, Node node2, Node node3) {
        return this.getEndpoint(node1, node2) == Endpoint.ARROW && this.getEndpoint(node3, node2) == Endpoint.ARROW;
    }

    @Override
    public boolean existsDirectedPathFromTo(Node node1, Node node2) {
        return this.existsDirectedPathVisit(node1, node2, new LinkedList<Node>());
    }

    @Override
    public boolean existsUndirectedPathFromTo(Node node1, Node node2) {
        return this.existsUndirectedPathVisit(node1, node2, new LinkedList<Node>());
    }

    @Override
    public boolean existsSemiDirectedPathFromTo(Node node1, Set<Node> nodes) {
        return this.existsSemiDirectedPathVisit(node1, nodes, new LinkedList<Node>());
    }

    @Override
    public boolean existsTrek(Node node1, Node node2) {
        for (Node node3 : this.getNodes()) {
            Node node = node3;
            if (!this.isAncestorOf(node, node1) || !this.isAncestorOf(node, node2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Node> getChildren(Node node) {
        LinkedList<Node> children = new LinkedList<Node>();
        for (Edge o : this.getEdges(node)) {
            Edge edge = o;
            Node sub = Edges.traverseDirected(node, edge);
            if (sub == null) continue;
            children.add(sub);
        }
        return children;
    }

    @Override
    public int getConnectivity() {
        int connectivity = 0;
        List<Node> nodes = this.getNodes();
        for (Node node : nodes) {
            int n = this.getNumEdges(node);
            if (n <= connectivity) continue;
            connectivity = n;
        }
        return connectivity;
    }

    @Override
    public List<Node> getDescendants(List<Node> nodes) {
        HashSet<Node> descendants = new HashSet<Node>();
        Iterator<Node> i$ = nodes.iterator();
        while (i$.hasNext()) {
            Node node1;
            Node node = node1 = i$.next();
            this.collectDescendantsVisit(node, descendants);
        }
        return new LinkedList<Node>(descendants);
    }

    @Override
    public Edge getEdge(Node node1, Node node2) {
        List<Edge> edges = this.getEdges(node1, node2);
        if (edges.size() == 0) {
            return null;
        }
        return edges.get(0);
    }

    @Override
    public Edge getDirectedEdge(Node node1, Node node2) {
        List<Edge> edges = this.getEdges(node1, node2);
        if (edges.size() == 0) {
            return null;
        }
        for (Edge edge : edges) {
            if (!Edges.isDirectedEdge(edge) || edge.getProximalEndpoint(node2) != Endpoint.ARROW) continue;
            return edge;
        }
        return null;
    }

    @Override
    public List<Node> getParents(Node node) {
        LinkedList<Node> parents = new LinkedList<Node>();
        for (Edge o : this.getEdges(node)) {
            Edge edge = o;
            Node sub = Edges.traverseReverseDirected(node, edge);
            if (sub == null) continue;
            parents.add(sub);
        }
        return parents;
    }

    @Override
    public int getIndegree(Node node) {
        return this.getParents(node).size();
    }

    @Override
    public int getOutdegree(Node node) {
        return this.getChildren(node).size();
    }

    @Override
    public boolean isAdjacentTo(Node node1, Node node2) {
        for (Edge edge : this.getEdges(node1)) {
            if (edge.getNode1() == edge.getNode2()) {
                throw new IllegalArgumentException("The two nodes are the same: " + edge.getNode1());
            }
            if (Edges.traverse(node1, edge) != node2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAncestorOf(Node node1, Node node2) {
        return node1 == node2 || this.isProperAncestorOf(node1, node2);
    }

    @Override
    public boolean possibleAncestor(Node node1, Node node2) {
        return this.existsSemiDirectedPathFromTo(node1, Collections.singleton(node2));
    }

    public boolean possibleAncestorSet(Node node1, List<Node> nodes2) {
        for (Node aNodes2 : nodes2) {
            if (!this.possibleAncestor(node1, aNodes2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Node> getAncestors(List<Node> nodes) {
        HashSet<Node> ancestors = new HashSet<Node>();
        Iterator<Node> i$ = nodes.iterator();
        while (i$.hasNext()) {
            Node node1;
            Node node = node1 = i$.next();
            this.collectAncestorsVisit(node, ancestors);
        }
        return new LinkedList<Node>(ancestors);
    }

    @Override
    public boolean isChildOf(Node node1, Node node2) {
        for (Edge o : this.getEdges(node2)) {
            Edge edge = o;
            Node sub = Edges.traverseDirected(node2, edge);
            if (sub != node1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDescendentOf(Node node1, Node node2) {
        return node1 == node2 || this.isProperDescendentOf(node1, node2);
    }

    @Override
    public boolean defNonDescendent(Node node1, Node node2) {
        return !this.possibleAncestor(node1, node2);
    }

    @Override
    public boolean isDConnectedTo(Node node1, Node node2, List<Node> conditioningNodes) {
        LinkedList<Node> path = new LinkedList<Node>();
        HashSet<Node> conditioningNodesClosure = new HashSet<Node>();
        for (Node conditioningNode : conditioningNodes) {
            this.doParentClosureVisit(conditioningNode, conditioningNodesClosure);
        }
        Endpoint incomingEndpoint = null;
        return this.isDConnectedToVisit(node1, incomingEndpoint, incomingEndpoint, node2, path, conditioningNodes, conditioningNodesClosure);
    }

    @Override
    public boolean isDSeparatedFrom(Node node1, Node node2, List<Node> z) {
        return !this.isDConnectedTo(node1, node2, z);
    }

    @Override
    public boolean possDConnectedTo(Node node1, Node node2, List<Node> condNodes) {
        LinkedList<Node> allNodes = new LinkedList<Node>(this.getNodes());
        int sz = allNodes.size();
        int[][] edgeStage = new int[sz][sz];
        int stage = 1;
        int n1x = allNodes.indexOf(node1);
        int n2x = allNodes.indexOf(node2);
        edgeStage[n1x][n1x] = 1;
        edgeStage[n2x][n2x] = 1;
        LinkedList<int[]> nextEdges = new LinkedList<int[]>();
        int[] temp1 = new int[]{n1x, n1x};
        nextEdges.add(temp1);
        int[] temp2 = new int[]{n2x, n2x};
        nextEdges.add(temp2);
        while (true) {
            LinkedList<int[]> currEdges = nextEdges;
            nextEdges = new LinkedList();
            for (int[] edge : currEdges) {
                Node center = allNodes.get(edge[1]);
                LinkedList<Node> adj = new LinkedList<Node>(this.getAdjacentNodes(center));
                for (Node anAdj : adj) {
                    Node Z;
                    Node Y;
                    Node X;
                    int testIndex = allNodes.indexOf(anAdj);
                    if (edgeStage[edge[1]][testIndex] != 0 || (!this.isDefNoncollider(X = allNodes.get(edge[0]), Y = allNodes.get(edge[1]), Z = allNodes.get(testIndex)) || condNodes.contains(Y)) && (!this.isDefCollider(X, Y, Z) || !this.possibleAncestorSet(Y, condNodes))) continue;
                    if (((Object)anAdj).equals(node2)) {
                        return true;
                    }
                    int[] nextEdge = new int[]{edge[1], testIndex};
                    nextEdges.add(nextEdge);
                    edgeStage[edge[1]][testIndex] = stage;
                    edgeStage[testIndex][edge[1]] = stage;
                }
            }
            if (nextEdges.size() == 0) break;
            ++stage;
        }
        return false;
    }

    @Override
    public boolean existsInducingPath(Node node1, Node node2, Set<Node> observedNodes, Set<Node> conditioningNodes) {
        HashSet<Node> sPlus = new HashSet<Node>(conditioningNodes);
        HashSet<Node> pathNodes = new HashSet<Node>();
        sPlus.add(node1);
        sPlus.add(node2);
        HashSet<Node> sClosure = new HashSet<Node>();
        for (Node s : sPlus) {
            this.doParentClosureVisit(s, sClosure);
        }
        return this.existsInducingPathVisit(node1, node2, null, pathNodes, observedNodes, conditioningNodes, sClosure);
    }

    @Override
    public boolean isParentOf(Node node1, Node node2) {
        for (Edge edge1 : this.getEdges(node1)) {
            Edge edge = edge1;
            Node sub = Edges.traverseDirected(node1, edge);
            if (sub != node2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isProperAncestorOf(Node node1, Node node2) {
        return this.existsDirectedPathFromTo(node1, node2);
    }

    @Override
    public boolean isProperDescendentOf(Node node1, Node node2) {
        return this.existsDirectedPathFromTo(node2, node1);
    }

    @Override
    public void transferNodesAndEdges(Graph graph) throws IllegalArgumentException {
        if (graph == null) {
            throw new NullPointerException("No graph was provided.");
        }
        for (Node o : graph.getNodes()) {
            Node node = o;
            if (this.addNode(node)) continue;
            throw new IllegalArgumentException();
        }
        for (Edge o1 : graph.getEdges()) {
            Edge edge = o1;
            if (this.addEdge(edge)) continue;
            System.out.println(edge + " not added.");
            throw new IllegalArgumentException();
        }
    }

    @Override
    public boolean isExogenous(Node node) {
        return this.getIndegree(node) == 0;
    }

    @Override
    public List<Node> getAdjacentNodes(Node node) {
        HashSet<Node> adjacentNodesHash = new HashSet<Node>();
        LinkedList<Node> adjacentNodes = new LinkedList<Node>();
        List<Edge> edges = this.getEdges(node);
        for (Edge edge : edges) {
            Node _node = edge.getDistalNode(node);
            if (adjacentNodesHash.contains(_node)) continue;
            adjacentNodesHash.add(_node);
            adjacentNodes.add(_node);
        }
        return adjacentNodes;
    }

    @Override
    public boolean removeEdge(Node node1, Node node2) {
        List<Edge> edges = this.getEdges(node1, node2);
        if (edges.size() > 1) {
            throw new IllegalStateException("There is more than one edge between " + node1 + " and " + node2);
        }
        return this.removeEdges(edges);
    }

    @Override
    public Endpoint getEndpoint(Node node1, Node node2) {
        List<Edge> edges = this.getEdges(node1, node2);
        if (edges.size() == 0) {
            return null;
        }
        if (edges.size() > 1) {
            throw new IllegalArgumentException("More than one edge between " + node1 + " and " + node2);
        }
        return edges.get(0).getProximalEndpoint(node2);
    }

    @Override
    public boolean setEndpoint(Node from, Node to, Endpoint endPoint) throws IllegalArgumentException {
        List<Edge> edges = this.getEdges(from, to);
        if (endPoint == null) {
            this.removeEdge(from, to);
            return true;
        }
        if (edges.size() == 0) {
            this.addEdge(new Edge(from, to, Endpoint.TAIL, endPoint));
            return true;
        }
        if (edges.size() == 1) {
            Edge currentEdge = this.getEdge(from, to);
            Edge edge = edges.get(0);
            Edge newEdge = new Edge(from, to, edge.getProximalEndpoint(from), endPoint);
            this.removeEdge(currentEdge);
            try {
                this.addEdge(newEdge);
                return true;
            }
            catch (IllegalArgumentException e) {
                this.addEdge(currentEdge);
                return false;
            }
        }
        throw new NullPointerException("An endpoint between node1 and node2 may not be set in this graph if there is more than one edge between node1 and node2.");
    }

    @Override
    public List<Node> getNodesInTo(Node node, Endpoint endpoint) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        List<Edge> edges = this.getEdges(node);
        for (Edge edge1 : edges) {
            Edge edge = edge1;
            if (edge.getProximalEndpoint(node) != endpoint) continue;
            nodes.add(edge.getDistalNode(node));
        }
        return nodes;
    }

    @Override
    public List<Node> getNodesOutTo(Node node, Endpoint endpoint) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        List<Edge> edges = this.getEdges(node);
        for (Edge edge1 : edges) {
            Edge edge = edge1;
            if (edge.getDistalEndpoint(node) != endpoint) continue;
            nodes.add(edge.getDistalNode(node));
        }
        return nodes;
    }

    @Override
    public Endpoint[][] getEndpointMatrix() {
        int size = this.nodes.size();
        Endpoint[][] endpoints = new Endpoint[size][size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (i == j) continue;
                Node nodei = this.nodes.get(i);
                Node nodej = this.nodes.get(j);
                endpoints[i][j] = this.getEndpoint(nodei, nodej);
            }
        }
        return endpoints;
    }

    @Override
    public boolean addEdge(Edge edge) {
        Node node;
        if (this.isGraphConstraintsChecked() && !this.checkAddEdge(edge)) {
            throw new IllegalArgumentException("Violates graph constraints: " + edge);
        }
        List<Edge> edgeList1 = this.edgeLists.get(edge.getNode1());
        List<Edge> edgeList2 = this.edgeLists.get(edge.getNode2());
        if (edgeList1 == null || edgeList2 == null) {
            this.reconstituteMaps();
            edgeList1 = this.edgeLists.get(edge.getNode1());
            edgeList2 = this.edgeLists.get(edge.getNode2());
        }
        if (edgeList1 == null || edgeList2 == null) {
            throw new NullPointerException("Can't add an edge unless both nodes are in the graph: " + edge);
        }
        if (edgeList1.contains(edge)) {
            throw new IllegalArgumentException("That edge is already in the graph: " + edge);
        }
        if (edgeList2.contains(edge)) {
            throw new IllegalArgumentException("That edge is already in the graph: " + edge);
        }
        edgeList1.add(edge);
        edgeList2.add(edge);
        this.edges.add(edge);
        if (Edges.isDirectedEdge(edge) && (node = Edges.getDirectedEdgeTail(edge)).getNodeType() == NodeType.ERROR) {
            this.getPcs().firePropertyChange("nodeAdded", null, node);
        }
        this.getPcs().firePropertyChange("edgeAdded", null, edge);
        return true;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().addPropertyChangeListener(l);
    }

    @Override
    public boolean addNode(Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (this.getNode(node.getName()) != null) {
            return false;
        }
        if (this.edgeLists.containsKey(node)) {
            return false;
        }
        if (this.nodes.contains(node)) {
            return false;
        }
        if (this.isGraphConstraintsChecked() && !this.checkAddNode(node)) {
            return false;
        }
        this.edgeLists.put(node, new LinkedList());
        this.nodes.add(node);
        if (node.getNodeType() != NodeType.ERROR) {
            this.getPcs().firePropertyChange("nodeAdded", null, node);
        }
        return true;
    }

    @Override
    public List<Edge> getEdges() {
        return new ArrayList<Edge>(this.edges);
    }

    @Override
    public boolean containsEdge(Edge edge) {
        return this.edges.contains(edge);
    }

    @Override
    public boolean containsNode(Node node) {
        return this.nodes.contains(node);
    }

    @Override
    public List<Edge> getEdges(Node node) {
        if (!this.nodes.contains(node)) {
            throw new IllegalArgumentException("Node not in graph: " + node);
        }
        List<Edge> list = this.edgeLists.get(node);
        if (list == null) {
            this.reconstituteMaps();
            list = this.edgeLists.get(node);
        }
        return Collections.unmodifiableList(list);
    }

    public int hashCode() {
        int hashCode = 17;
        for (Node node : this.getNodes()) {
            hashCode += 23 * ((Object)node).hashCode();
        }
        for (Edge edge : this.getEdges()) {
            hashCode += 29 * edge.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Graph graph = (Graph)o;
        List<Node> tNodes = this.getNodes();
        List<Node> oNodes = graph.getNodes();
        Iterator<Node> it = tNodes.iterator();
        block0: while (it.hasNext()) {
            Node thisNode = it.next();
            Iterator<Node> it2 = oNodes.iterator();
            while (it2.hasNext()) {
                Node otherNode = it2.next();
                if (!thisNode.getName().equals(otherNode.getName())) continue;
                it.remove();
                it2.remove();
                continue block0;
            }
        }
        if (!tNodes.isEmpty() || !oNodes.isEmpty()) {
            return false;
        }
        List<Edge> tEdges = this.getEdges();
        List<Edge> oEdges = graph.getEdges();
        Iterator<Edge> it2 = tEdges.iterator();
        block2: while (it2.hasNext()) {
            Edge thisEdge = it2.next();
            Iterator<Edge> it22 = oEdges.iterator();
            while (it22.hasNext()) {
                Edge otherEdge = it22.next();
                if (!thisEdge.equals(otherEdge)) continue;
                it2.remove();
                it22.remove();
                continue block2;
            }
        }
        return tEdges.isEmpty() && oEdges.isEmpty();
    }

    @Override
    public void fullyConnect(Endpoint endpoint) {
        this.edges.clear();
        this.edgeLists.clear();
        for (Node node : this.nodes) {
            this.edgeLists.put(node, new LinkedList());
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            for (int j = i + 1; j < this.nodes.size(); ++j) {
                Node node1 = this.nodes.get(i);
                Node node2 = this.nodes.get(j);
                Edge edge = new Edge(node1, node2, endpoint, endpoint);
                this.addEdge(edge);
            }
        }
    }

    @Override
    public void reorientAllWith(Endpoint endpoint) {
        for (Edge edge : new LinkedList<Edge>(this.edges)) {
            Node a = edge.getNode1();
            Node b = edge.getNode2();
            this.setEndpoint(a, b, endpoint);
            this.setEndpoint(b, a, endpoint);
        }
    }

    @Override
    public Node getNode(String name) {
        for (Node node : this.nodes) {
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getNumNodes() {
        return this.nodes.size();
    }

    @Override
    public int getNumEdges() {
        return this.edges.size();
    }

    @Override
    public int getNumEdges(Node node) {
        List<Edge> list = this.edgeLists.get(node);
        return list == null ? 0 : list.size();
    }

    @Override
    public List<GraphConstraint> getGraphConstraints() {
        return new LinkedList<GraphConstraint>(this.graphConstraints);
    }

    @Override
    public boolean isGraphConstraintsChecked() {
        return this.graphConstraintsChecked;
    }

    @Override
    public void setGraphConstraintsChecked(boolean checked) {
        this.graphConstraintsChecked = checked;
    }

    @Override
    public List<Node> getNodes() {
        return new ArrayList<Node>(this.nodes);
    }

    @Override
    public void clear() {
        Iterator<Edge> it = this.getEdges().iterator();
        while (it.hasNext()) {
            Edge edge = it.next();
            it.remove();
            this.getPcs().firePropertyChange("edgeRemoved", edge, null);
        }
        Iterator<Node> it2 = this.nodes.iterator();
        while (it2.hasNext()) {
            Node node = it2.next();
            it2.remove();
            this.getPcs().firePropertyChange("nodeRemoved", node, null);
        }
        this.edgeLists.clear();
    }

    @Override
    public boolean removeEdge(Edge edge) {
        if (this.edges.contains(edge) && !this.checkRemoveEdge(edge)) {
            return false;
        }
        List<Edge> edgeList1 = this.edgeLists.get(edge.getNode1());
        List<Edge> edgeList2 = this.edgeLists.get(edge.getNode2());
        this.edges.remove(edge);
        edgeList1.remove(edge);
        edgeList2.remove(edge);
        this.stuffRemovedSinceLastTripleAccess = true;
        this.getPcs().firePropertyChange("edgeRemoved", edge, null);
        return true;
    }

    @Override
    public boolean removeEdges(List<Edge> edges) {
        boolean change = false;
        for (Edge edge : edges) {
            boolean _change = this.removeEdge(edge);
            change = change || _change;
        }
        return change;
    }

    @Override
    public boolean removeEdges(Node node1, Node node2) {
        return this.removeEdges(this.getEdges(node1, node2));
    }

    @Override
    public boolean removeNode(Node node) {
        if (this.nodes.contains(node) && !this.checkRemoveNode(node)) {
            return false;
        }
        boolean changed = false;
        List<Edge> edgeList1 = this.edgeLists.get(node);
        Iterator<Edge> i = edgeList1.iterator();
        while (i.hasNext()) {
            Edge edge = i.next();
            Node node2 = edge.getDistalNode(node);
            if (node2 != node) {
                List<Edge> edgeList2 = this.edgeLists.get(node2);
                edgeList2.remove(edge);
                this.edges.remove(edge);
                changed = true;
            }
            i.remove();
            this.getPcs().firePropertyChange("edgeRemoved", edge, null);
        }
        this.edgeLists.remove(node);
        this.nodes.remove(node);
        this.stuffRemovedSinceLastTripleAccess = true;
        this.getPcs().firePropertyChange("nodeRemoved", node, null);
        return changed;
    }

    @Override
    public boolean removeNodes(List<Node> newNodes) {
        boolean changed = false;
        for (Node newNode : newNodes) {
            boolean _changed = this.removeNode(newNode);
            changed = changed || _changed;
        }
        return changed;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\nGraph Nodes:\n");
        for (int i = 0; i < this.nodes.size(); ++i) {
            buf.append(this.nodes.get(i) + " ");
            if ((i + 1) % 30 != 0) continue;
            buf.append("\n");
        }
        buf.append("\n\nGraph Edges: ");
        ArrayList<Edge> edges = new ArrayList<Edge>(this.edges);
        Edges.sortEdges(edges);
        for (int i = 0; i < edges.size(); ++i) {
            Edge edge = (Edge)edges.get(i);
            buf.append("\n").append(i + 1).append(". ").append(edge);
        }
        buf.append("\n");
        buf.append("\n");
        if (!this.ambiguousTriples.isEmpty()) {
            buf.append("Ambiguous triples (i.e. list of triples for which there is ambiguous data\nabout whether they are colliders or not): \n");
            for (Triple triple : this.ambiguousTriples) {
                buf.append(triple).append("\n");
            }
        }
        if (!this.underLineTriples.isEmpty()) {
            buf.append("Underline triples: \n");
            for (Triple triple : this.underLineTriples) {
                buf.append(triple).append("\n");
            }
        }
        if (!this.dottedUnderLineTriples.isEmpty()) {
            buf.append("Dotted underline triples: \n");
            for (Triple triple : this.dottedUnderLineTriples) {
                buf.append(triple).append("\n");
            }
        }
        return buf.toString();
    }

    @Override
    public Graph subgraph(List<Node> nodes) {
        EdgeListGraph graph = new EdgeListGraph(nodes);
        List<Edge> edges = this.getEdges();
        for (Edge edge1 : edges) {
            Edge edge = edge1;
            if (!nodes.contains(edge.getNode1()) || !nodes.contains(edge.getNode2())) continue;
            graph.addEdge(edge);
        }
        return graph;
    }

    @Override
    public List<Edge> getEdges(Node node1, Node node2) {
        LinkedList<Edge> edges = new LinkedList<Edge>(this.getEdges(node1));
        Iterator i = edges.iterator();
        while (i.hasNext()) {
            Edge edge = (Edge)i.next();
            if (edge.getDistalNode(node1) == node2) continue;
            i.remove();
        }
        return edges;
    }

    @Override
    public Set<Triple> getAmbiguousTriples() {
        this.removeTriplesNotInGraph();
        return new HashSet<Triple>(this.ambiguousTriples);
    }

    @Override
    public Set<Triple> getUnderLines() {
        this.removeTriplesNotInGraph();
        return new HashSet<Triple>(this.underLineTriples);
    }

    @Override
    public Set<Triple> getDottedUnderlines() {
        this.removeTriplesNotInGraph();
        return new HashSet<Triple>(this.dottedUnderLineTriples);
    }

    @Override
    public boolean isAmbiguousTriple(Node x, Node y, Node z) {
        Triple triple = new Triple(x, y, z);
        if (!triple.alongPathIn(this)) {
            throw new IllegalArgumentException("<" + x + ", " + y + ", " + z + "> is not along a path.");
        }
        this.removeTriplesNotInGraph();
        return this.ambiguousTriples.contains(triple);
    }

    @Override
    public boolean isUnderlineTriple(Node x, Node y, Node z) {
        Triple triple = new Triple(x, y, z);
        this.removeTriplesNotInGraph();
        return this.underLineTriples.contains(new Triple(x, y, z));
    }

    @Override
    public boolean isDottedUnderlineTriple(Node x, Node y, Node z) {
        Triple triple = new Triple(x, y, z);
        if (!triple.alongPathIn(this)) {
            throw new IllegalArgumentException("<" + x + ", " + y + ", " + z + "> is not along a path.");
        }
        this.removeTriplesNotInGraph();
        return this.dottedUnderLineTriples.contains(new Triple(x, y, z));
    }

    @Override
    public void addAmbiguousTriple(Node x, Node y, Node z) {
        Triple triple = new Triple(x, y, z);
        if (!triple.alongPathIn(this)) {
            throw new IllegalArgumentException("<" + x + ", " + y + ", " + z + "> must lie along a path in the graph.");
        }
        this.ambiguousTriples.add(new Triple(x, y, z));
    }

    @Override
    public void addUnderlineTriple(Node x, Node y, Node z) {
        Triple triple = new Triple(x, y, z);
        if (!triple.alongPathIn(this)) {
            throw new IllegalArgumentException("<" + x + ", " + y + ", " + z + "> must lie along a path in the graph.");
        }
        this.underLineTriples.add(new Triple(x, y, z));
    }

    @Override
    public void addDottedUnderlineTriple(Node x, Node y, Node z) {
        Triple triple = new Triple(x, y, z);
        if (!triple.alongPathIn(this)) {
            throw new IllegalArgumentException("<" + x + ", " + y + ", " + z + "> must lie along a path in the graph.");
        }
        this.dottedUnderLineTriples.add(triple);
    }

    @Override
    public void removeAmbiguousTriple(Node x, Node y, Node z) {
        this.ambiguousTriples.remove(new Triple(x, y, z));
    }

    @Override
    public void removeUnderlineTriple(Node x, Node y, Node z) {
        this.underLineTriples.remove(new Triple(x, y, z));
    }

    @Override
    public void removeDottedUnderlineTriple(Node x, Node y, Node z) {
        this.dottedUnderLineTriples.remove(new Triple(x, y, z));
    }

    @Override
    public void setAmbiguousTriples(Set<Triple> triples) {
        this.ambiguousTriples.clear();
        for (Triple triple : triples) {
            this.addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
        }
    }

    @Override
    public void setUnderLineTriples(Set<Triple> triples) {
        this.underLineTriples.clear();
        for (Triple triple : triples) {
            this.addUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
        }
    }

    @Override
    public void setDottedUnderLineTriples(Set<Triple> triples) {
        this.dottedUnderLineTriples.clear();
        for (Triple triple : triples) {
            this.addDottedUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
        }
    }

    @Override
    public List<String> getNodeNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Node node : this.getNodes()) {
            names.add(node.getName());
        }
        return names;
    }

    private void removeTriplesNotInGraph() {
        if (!this.stuffRemovedSinceLastTripleAccess) {
            return;
        }
        for (Triple triple : new HashSet<Triple>(this.ambiguousTriples)) {
            if (!(this.containsNode(triple.getX()) && this.containsNode(triple.getY()) && this.containsNode(triple.getZ()))) {
                this.ambiguousTriples.remove(triple);
                continue;
            }
            if (this.isAdjacentTo(triple.getX(), triple.getY()) && this.isAdjacentTo(triple.getY(), triple.getZ())) continue;
            this.ambiguousTriples.remove(triple);
        }
        for (Triple triple : new HashSet<Triple>(this.underLineTriples)) {
            if (!(this.containsNode(triple.getX()) && this.containsNode(triple.getY()) && this.containsNode(triple.getZ()))) {
                this.underLineTriples.remove(triple);
                continue;
            }
            if (this.isAdjacentTo(triple.getX(), triple.getY()) && this.isAdjacentTo(triple.getY(), triple.getZ())) continue;
            this.underLineTriples.remove(triple);
        }
        for (Triple triple : new HashSet<Triple>(this.dottedUnderLineTriples)) {
            if (!(this.containsNode(triple.getX()) && this.containsNode(triple.getY()) && this.containsNode(triple.getZ()))) {
                this.dottedUnderLineTriples.remove(triple);
                continue;
            }
            if (this.isAdjacentTo(triple.getX(), triple.getY()) && this.isAdjacentTo(triple.getY(), triple.getZ())) continue;
            this.dottedUnderLineTriples.remove(triple);
        }
        this.stuffRemovedSinceLastTripleAccess = false;
    }

    private void collectAncestorsVisit(Node node, Set<Node> ancestors) {
        ancestors.add(node);
        List<Node> parents = this.getParents(node);
        if (!parents.isEmpty()) {
            Iterator<Node> i$ = parents.iterator();
            while (i$.hasNext()) {
                Node parent1;
                Node parent = parent1 = i$.next();
                this.doParentClosureVisit(parent, ancestors);
            }
        }
    }

    private void collectDescendantsVisit(Node node, Set<Node> descendants) {
        descendants.add(node);
        List<Node> children = this.getChildren(node);
        if (!children.isEmpty()) {
            Iterator<Node> i$ = children.iterator();
            while (i$.hasNext()) {
                Node aChildren;
                Node child = aChildren = i$.next();
                this.doChildClosureVisit(child, descendants);
            }
        }
    }

    private void doChildClosureVisit(Node node, Set<Node> closure) {
        if (!closure.contains(node)) {
            closure.add(node);
            for (Edge edge1 : this.getEdges(node)) {
                Node sub = Edges.traverseDirected(node, edge1);
                if (sub == null) continue;
                this.doChildClosureVisit(sub, closure);
            }
        }
    }

    private void doParentClosureVisit(Node node, Set<Node> closure) {
        if (!closure.contains(node)) {
            closure.add(node);
            for (Edge edge1 : this.getEdges(node)) {
                Node sub = Edges.traverseReverseDirected(node, edge1);
                if (sub == null) continue;
                this.doParentClosureVisit(sub, closure);
            }
        }
    }

    private boolean isDConnectedToVisit(Node currentNode, Endpoint actualInEdgeEndpoint, Endpoint inEdgeEndpoint, Node targetNode, LinkedList<Node> path, List<Node> conditioningNodes, Set<Node> conditioningNodesClosure) {
        if (currentNode == targetNode) {
            return true;
        }
        if (path.contains(currentNode)) {
            return false;
        }
        path.addLast(currentNode);
        for (Edge edge1 : this.getEdges(currentNode)) {
            Endpoint previousEndpoint;
            Endpoint previousActual;
            Node nextNode;
            boolean passAsNonCollider;
            Endpoint outEdgeEndpoint = edge1.getProximalEndpoint(currentNode);
            boolean isCollider = inEdgeEndpoint == Endpoint.ARROW && outEdgeEndpoint == Endpoint.ARROW;
            boolean passAsCollider = isCollider && conditioningNodesClosure.contains(currentNode);
            boolean bl = passAsNonCollider = !isCollider && !conditioningNodes.contains(currentNode);
            if (passAsCollider && actualInEdgeEndpoint != null && !actualInEdgeEndpoint.equals(Endpoint.ARROW)) {
                passAsCollider = false;
            }
            if (!passAsCollider && !passAsNonCollider || !this.isDConnectedToVisit(nextNode = Edges.traverse(currentNode, edge1), previousActual = edge1.getProximalEndpoint(nextNode), previousEndpoint = inEdgeEndpoint != null && inEdgeEndpoint.equals(Endpoint.ARROW) && passAsNonCollider ? Endpoint.ARROW : previousActual, targetNode, path, conditioningNodes, conditioningNodesClosure)) continue;
            return true;
        }
        path.removeLast();
        return false;
    }

    private boolean existsInducingPathVisit(Node node1, Node node2, Endpoint inEnd, Set<Node> pathNodes, Set<Node> observedNodes, Set<Node> conditioningNodes, Set<Node> sClosure) {
        if (node1 == node2) {
            return true;
        }
        if (pathNodes.contains(node1)) {
            return false;
        }
        pathNodes.add(node1);
        for (Edge edge1 : this.getEdges(node1)) {
            Endpoint newIn;
            Node sub;
            boolean passAsNonCollider;
            Endpoint outEnd = edge1.getProximalEndpoint(node1);
            boolean isCollider = inEnd == Endpoint.ARROW && outEnd == Endpoint.ARROW;
            boolean passAsCollider = isCollider && sClosure.contains(node1);
            boolean bl = passAsNonCollider = !isCollider && !observedNodes.contains(node1) && !conditioningNodes.contains(node1);
            if (!passAsCollider && !passAsNonCollider || !this.existsInducingPathVisit(sub = Edges.traverse(node1, edge1), node2, newIn = edge1.getProximalEndpoint(sub), pathNodes, observedNodes, conditioningNodes, sClosure)) continue;
            return true;
        }
        pathNodes.remove(node1);
        return false;
    }

    private boolean checkAddNode(Node node) {
        for (GraphConstraint graphConstraint : this.graphConstraints) {
            GraphConstraint gc = graphConstraint;
            if (gc.isNodeAddable(node, this)) continue;
            return false;
        }
        return true;
    }

    private boolean checkAddEdge(Edge edge) {
        for (GraphConstraint graphConstraint : this.graphConstraints) {
            GraphConstraint gc = graphConstraint;
            if (gc.isEdgeAddable(edge, this)) continue;
            System.out.println("Edge " + edge + " failed " + gc);
            return false;
        }
        return true;
    }

    private boolean checkRemoveNode(Node node) {
        for (GraphConstraint graphConstraint : this.graphConstraints) {
            GraphConstraint gc = graphConstraint;
            if (gc.isNodeRemovable(node, this)) continue;
            return false;
        }
        return true;
    }

    private boolean checkRemoveEdge(Edge edge) {
        for (GraphConstraint graphConstraint : this.graphConstraints) {
            GraphConstraint gc = graphConstraint;
            if (gc.isEdgeRemovable(edge, this)) continue;
            return false;
        }
        return true;
    }

    private PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    private boolean existsUndirectedPathVisit(Node node1, Node node2, LinkedList<Node> path) {
        path.addLast(node1);
        for (Edge edge : this.getEdges(node1)) {
            Node child = Edges.traverse(node1, edge);
            if (child == null) continue;
            if (child == node2) {
                return true;
            }
            if (path.contains(child) || !this.existsUndirectedPathVisit(child, node2, path)) continue;
            return true;
        }
        path.removeLast();
        return false;
    }

    private boolean existsDirectedPathVisit(Node node1, Node node2, LinkedList<Node> path) {
        path.addLast(node1);
        for (Edge edge : this.getEdges(node1)) {
            Node child = Edges.traverseDirected(node1, edge);
            if (child == null) continue;
            if (child == node2) {
                return true;
            }
            if (path.contains(child) || !this.existsDirectedPathVisit(child, node2, path)) continue;
            return true;
        }
        path.removeLast();
        return false;
    }

    private boolean existsSemiDirectedPathVisit(Node node1, Set<Node> nodes2, LinkedList<Node> path) {
        path.addLast(node1);
        for (Edge edge : this.getEdges(node1)) {
            Node child = Edges.traverseSemiDirected(node1, edge);
            if (child == null) continue;
            if (nodes2.contains(child)) {
                return true;
            }
            if (path.contains(child) || !this.existsSemiDirectedPathVisit(child, nodes2, path)) continue;
            return true;
        }
        path.removeLast();
        return false;
    }

    private void reconstituteMaps() {
        this.edgeLists = new HashMap<Node, List<Edge>>(this.edgeLists);
    }

    @Override
    public List<Node> getTierOrdering() {
        LinkedList<Node> found = new LinkedList<Node>();
        HashSet<Node> notFound = new HashSet<Node>();
        for (Node node1 : this.getNodes()) {
            notFound.add(node1);
        }
        while (!notFound.isEmpty()) {
            Iterator it = notFound.iterator();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                if (!found.containsAll(this.getParents(node))) continue;
                found.add(node);
                it.remove();
            }
        }
        return found;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.nodes == null) {
            throw new NullPointerException();
        }
        if (this.edges == null) {
            throw new NullPointerException();
        }
        if (this.edgeLists == null) {
            throw new NullPointerException();
        }
        if (this.graphConstraints == null) {
            throw new NullPointerException();
        }
        if (this.ambiguousTriples == null) {
            this.ambiguousTriples = new HashSet<Triple>();
        }
        if (this.ambiguousPairs == null) {
            this.ambiguousPairs = new HashSet<Pair>();
        }
    }
}

