/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public final class FruchtermanReingoldLayout {
    private Graph graph;
    private int[][] edges;
    private double[][] nodePosition;
    private double[][] nodeDisposition;
    private double optimalDistance;
    private final int numIterations = 6000;
    private double temperature;
    private double leftmostX = -50.0;

    public FruchtermanReingoldLayout(Graph graph) {
        if (graph == null) {
            throw new NullPointerException();
        }
        this.graph = graph;
    }

    public void doLayout() {
        List<List<Node>> components = GraphUtils.connectedComponents(this.graph());
        Collections.sort(components, new Comparator<List<Node>>(){

            @Override
            public int compare(List<Node> o1, List<Node> o2) {
                int i1 = o1.size();
                int i2 = o2.size();
                return i2 < i1 ? -1 : (i2 == i1 ? 0 : 1);
            }
        });
        for (List<Node> component1 : components) {
            this.layoutComponent(component1);
        }
    }

    private void layoutComponent(List<Node> nodes) {
        int i;
        Edge edge;
        int numNodes = nodes.size();
        this.nodePosition = new double[numNodes][2];
        this.nodeDisposition = new double[numNodes][2];
        for (int i2 = 0; i2 < numNodes; ++i2) {
            Node node = nodes.get(i2);
            this.nodePosition()[i2][0] = node.getCenterX();
            this.nodePosition()[i2][1] = node.getCenterY();
        }
        List<Edge> edges = this.graph().getEdges();
        Iterator<Edge> i3 = edges.iterator();
        while (i3.hasNext()) {
            edge = i3.next();
            if (nodes.contains(edge.getNode1()) && nodes.contains(edge.getNode2())) continue;
            i3.remove();
        }
        this.edges = new int[edges.size()][2];
        for (i = 0; i < edges.size(); ++i) {
            edge = edges.get(i);
            int v = nodes.indexOf(edge.getNode1());
            int u = nodes.indexOf(edge.getNode2());
            this.edges()[i][0] = v;
            this.edges()[i][1] = u;
        }
        this.setOptimalDistance(60.0);
        this.setTemperature(5.0);
        for (i = 0; i < this.numIterations(); ++i) {
            int v;
            for (v = 0; v < numNodes; ++v) {
                this.nodeDisposition()[v][0] = 0.0;
                this.nodeDisposition()[v][1] = 0.0;
                for (int u = 0; u < numNodes; ++u) {
                    double deltaY;
                    double deltaX = this.nodePosition()[u][0] - this.nodePosition()[v][0];
                    double norm = this.norm(deltaX, deltaY = this.nodePosition()[u][1] - this.nodePosition()[v][1]);
                    if (norm == 0.0 || norm > 4.0 * this.optimalDistance()) continue;
                    double repulsiveForce = this.fr(norm);
                    double[] dArray = this.nodeDisposition()[v];
                    dArray[0] = dArray[0] + deltaX / norm * repulsiveForce;
                    double[] dArray2 = this.nodeDisposition()[v];
                    dArray2[1] = dArray2[1] + deltaY / norm * repulsiveForce;
                }
            }
            for (int j = 0; j < edges.size(); ++j) {
                double deltaY;
                int u = this.edges()[j][0];
                int v2 = this.edges()[j][1];
                double deltaX = this.nodePosition()[v2][0] - this.nodePosition()[u][0];
                double norm = this.norm(deltaX, deltaY = this.nodePosition()[v2][1] - this.nodePosition()[u][1]);
                if (norm == 0.0 || norm < 1.5 * this.optimalDistance()) continue;
                double attractiveForce = this.fa(norm);
                double attractX = deltaX / norm * attractiveForce;
                double attractY = deltaY / norm * attractiveForce;
                double[] dArray = this.nodeDisposition()[v2];
                dArray[0] = dArray[0] - attractX;
                double[] dArray3 = this.nodeDisposition()[v2];
                dArray3[1] = dArray3[1] - attractY;
                if (Double.isNaN(this.nodeDisposition()[v2][0]) || Double.isNaN(this.nodeDisposition()[v2][1])) {
                    throw new IllegalStateException("Undefined disposition.");
                }
                double[] dArray4 = this.nodeDisposition()[u];
                dArray4[0] = dArray4[0] + attractX;
                double[] dArray5 = this.nodeDisposition()[u];
                dArray5[1] = dArray5[1] + attractY;
                if (!Double.isNaN(this.nodeDisposition()[u][0]) && !Double.isNaN(this.nodeDisposition()[u][1])) continue;
                throw new IllegalStateException("Undefined disposition.");
            }
            for (v = 0; v < numNodes; ++v) {
                double norm = this.norm(this.nodeDisposition()[v][0], this.nodeDisposition()[v][1]);
                if (norm == 0.0) continue;
                double[] dArray = this.nodePosition()[v];
                dArray[0] = dArray[0] + this.nodeDisposition()[v][0] / norm * Math.min(norm, this.temperature());
                double[] dArray6 = this.nodePosition()[v];
                dArray6[1] = dArray6[1] + this.nodeDisposition()[v][1] / norm * Math.min(norm, this.temperature());
                if (!Double.isNaN(this.nodePosition()[v][0]) && !Double.isNaN(this.nodePosition()[v][1])) continue;
                throw new IllegalStateException("Undefined position.");
            }
        }
        this.shiftComponentToRight(nodes);
    }

    private void shiftComponentToRight(List<Node> componentNodes) {
        int i;
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        for (i = 0; i < componentNodes.size(); ++i) {
            if (this.nodePosition()[i][0] < minX) {
                minX = this.nodePosition()[i][0];
            }
            if (!(this.nodePosition()[i][1] < minY)) continue;
            minY = this.nodePosition()[i][1];
        }
        this.leftmostX = this.leftmostX() + 100.0;
        for (i = 0; i < componentNodes.size(); ++i) {
            double[] dArray = this.nodePosition()[i];
            dArray[0] = dArray[0] + (this.leftmostX() - minX);
            double[] dArray2 = this.nodePosition()[i];
            dArray2[1] = dArray2[1] + (40.0 - minY);
        }
        for (i = 0; i < componentNodes.size(); ++i) {
            if (!(this.nodePosition()[i][0] > this.leftmostX())) continue;
            this.leftmostX = this.nodePosition()[i][0];
        }
        for (i = 0; i < componentNodes.size(); ++i) {
            Node node = componentNodes.get(i);
            node.setCenterX((int)this.nodePosition()[i][0]);
            node.setCenterY((int)this.nodePosition()[i][1]);
        }
    }

    private double fa(double d) {
        return d * d / this.optimalDistance();
    }

    private double fr(double d) {
        return -(this.optimalDistance() * this.optimalDistance()) / d;
    }

    private double norm(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    private Graph graph() {
        return this.graph;
    }

    private int[][] edges() {
        return this.edges;
    }

    private double[][] nodePosition() {
        return this.nodePosition;
    }

    private double[][] nodeDisposition() {
        return this.nodeDisposition;
    }

    private double optimalDistance() {
        return this.getOptimalDistance();
    }

    private int numIterations() {
        return 6000;
    }

    private double temperature() {
        return this.getTemperature();
    }

    private double leftmostX() {
        return this.leftmostX;
    }

    private double getOptimalDistance() {
        return this.optimalDistance;
    }

    private void setOptimalDistance(double optimalDistance) {
        this.optimalDistance = optimalDistance;
    }

    private double getTemperature() {
        return this.temperature;
    }

    private void setTemperature(double temperature) {
        this.temperature = temperature;
    }
}

