/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import java.util.StringTokenizer;

public final class GraphConverter {
    public static Graph convert(String spec) {
        EdgeListGraph graph = new EdgeListGraph();
        StringTokenizer st1 = new StringTokenizer(spec, ", ");
        while (st1.hasMoreTokens()) {
            Node nodeB;
            Node nodeA;
            Edge edge;
            String edgeSpec = st1.nextToken();
            StringTokenizer st2 = new StringTokenizer(edgeSpec, "<>-o ");
            String var1 = st2.nextToken();
            if (var1.startsWith("Latent(")) {
                String latentName = (String)var1.subSequence(7, var1.length() - 1);
                GraphNode node = new GraphNode(latentName);
                node.setNodeType(NodeType.LATENT);
                graph.addNode(node);
                continue;
            }
            if (!st2.hasMoreTokens()) {
                graph.addNode(new GraphNode(var1));
                continue;
            }
            String var2 = st2.nextToken();
            if (graph.getNode(var1) == null) {
                graph.addNode(new GraphNode(var1));
            }
            if (graph.getNode(var2) == null) {
                graph.addNode(new GraphNode(var2));
            }
            if ((edge = graph.getEdge(nodeA = graph.getNode(var1), nodeB = graph.getNode(var2))) != null) {
                throw new IllegalArgumentException("Multiple edges connecting nodes is not supported.");
            }
            if (edgeSpec.lastIndexOf("-->") != -1) {
                graph.addDirectedEdge(nodeA, nodeB);
            }
            if (edgeSpec.lastIndexOf("<--") != -1) {
                graph.addDirectedEdge(nodeB, nodeA);
                continue;
            }
            if (edgeSpec.lastIndexOf("---") != -1) {
                graph.addUndirectedEdge(nodeA, nodeB);
                continue;
            }
            if (edgeSpec.lastIndexOf("<->") != -1) {
                graph.addBidirectedEdge(nodeA, nodeB);
                continue;
            }
            if (edgeSpec.lastIndexOf("o->") != -1) {
                graph.addPartiallyOrientedEdge(nodeA, nodeB);
                continue;
            }
            if (edgeSpec.lastIndexOf("<-o") != -1) {
                graph.addPartiallyOrientedEdge(nodeB, nodeA);
                continue;
            }
            if (edgeSpec.lastIndexOf("o-o") == -1) continue;
            graph.addNondirectedEdge(nodeB, nodeA);
        }
        return graph;
    }
}

