/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.util.TetradSerializable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;

public class GraphNode
implements Node,
TetradSerializable {
    static final long serialVersionUID = 23L;
    private String name = "??";
    private NodeType nodeType = NodeType.MEASURED;
    private int centerX = -1;
    private int centerY = -1;
    private transient PropertyChangeSupport pcs;

    public GraphNode(String name) {
        this.setName(name);
    }

    public GraphNode(GraphNode node) {
        this.name = node.name;
        this.nodeType = node.nodeType;
        this.centerX = node.centerX;
        this.centerY = node.centerY;
    }

    public static GraphNode serializableInstance() {
        return new GraphNode("X");
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final NodeType getNodeType() {
        return this.nodeType;
    }

    @Override
    public final void setNodeType(NodeType nodeType) {
        if (nodeType == null) {
            throw new NullPointerException("Node type must not be null.");
        }
        this.nodeType = nodeType;
    }

    @Override
    public final void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        String oldName = this.name;
        this.name = name;
        this.getPcs().firePropertyChange("name", oldName, this.name);
    }

    @Override
    public final int getCenterX() {
        return this.centerX;
    }

    @Override
    public final void setCenterX(int centerX) {
        this.centerX = centerX;
    }

    @Override
    public final int getCenterY() {
        return this.centerY;
    }

    @Override
    public final void setCenterY(int centerY) {
        this.centerY = centerY;
    }

    @Override
    public final void setCenter(int centerX, int centerY) {
        this.centerX = centerX;
        this.centerY = centerY;
    }

    private PropertyChangeSupport getPcs() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.getPcs().removePropertyChangeListener(l);
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public int hashCode() {
        int hashCode = 63;
        hashCode = 17 * hashCode + this.getName().hashCode();
        hashCode = 17 * hashCode + this.getNodeType().hashCode();
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof GraphNode)) {
            return false;
        }
        GraphNode node = (GraphNode)o;
        if (!this.getName().equals(node.getName())) {
            return false;
        }
        return this.getNodeType() == node.getNodeType();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.name == null) {
            throw new NullPointerException();
        }
        if (this.nodeType == null) {
            throw new NullPointerException();
        }
    }
}

