/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConstraint;
import edu.cmu.tetrad.graph.Node;

public final class InArrowImpliesNonancestor
implements GraphConstraint {
    static final long serialVersionUID = 23L;

    public static InArrowImpliesNonancestor serializableInstance() {
        return new InArrowImpliesNonancestor();
    }

    @Override
    public boolean isEdgeAddable(Edge edge, Graph graph) {
        if (edge.getEndpoint1() == Endpoint.ARROW && graph.isProperAncestorOf(edge.getNode1(), edge.getNode2())) {
            return false;
        }
        return edge.getEndpoint2() != Endpoint.ARROW || !graph.isProperAncestorOf(edge.getNode2(), edge.getNode1());
    }

    @Override
    public boolean isNodeAddable(Node node, Graph graph) {
        return true;
    }

    @Override
    public boolean isEdgeRemovable(Edge edge, Graph graph) {
        return true;
    }

    @Override
    public boolean isNodeRemovable(Node node, Graph graph) {
        return true;
    }

    @Override
    public String toString() {
        return "<Arrow implies non-ancestor.>";
    }
}

