/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Node;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class IndependenceFact {
    private Node x;
    private Node y;
    private Set<Node> z;

    public IndependenceFact(Node x, Node y, List<Node> z) {
        if (x == null || y == null || z == null) {
            throw new NullPointerException();
        }
        this.x = x;
        this.y = y;
        this.z = new LinkedHashSet<Node>(z);
    }

    public final Node getX() {
        return this.x;
    }

    public final Node getY() {
        return this.y;
    }

    public final List<Node> getZ() {
        return new LinkedList<Node>(this.z);
    }

    public final int hashCode() {
        int hash = 17;
        hash += 19 * ((Object)this.x).hashCode() * ((Object)this.y).hashCode();
        return hash += 23 * ((Object)this.z).hashCode();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof IndependenceFact)) {
            return false;
        }
        IndependenceFact fact = (IndependenceFact)obj;
        return ((Object)this.z).equals(fact.z) && (((Object)this.x).equals(fact.x) && ((Object)this.y).equals(fact.y) || ((Object)this.x).equals(fact.y) && ((Object)this.y).equals(fact.x));
    }

    public String toString() {
        return this.x + " _||_ " + this.y + " | " + this.z;
    }
}

