/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.FruchtermanReingoldLayout;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestFruchtermanReingoldLayout
extends TestCase {
    public TestFruchtermanReingoldLayout(String name) {
        super(name);
    }

    public void testLayout() {
        Dag dag = new Dag();
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        GraphNode x3 = new GraphNode("X3");
        GraphNode x4 = new GraphNode("X4");
        GraphNode x5 = new GraphNode("X5");
        GraphNode x6 = new GraphNode("X6");
        GraphNode x7 = new GraphNode("X7");
        dag.addNode(x1);
        dag.addNode(x2);
        dag.addNode(x3);
        dag.addNode(x4);
        dag.addNode(x5);
        dag.addNode(x6);
        dag.addNode(x7);
        dag.addDirectedEdge(x1, x2);
        dag.addDirectedEdge(x2, x3);
        dag.addDirectedEdge(x4, x5);
        dag.addDirectedEdge(x5, x6);
        GraphUtils.arrangeInCircle(dag, 200, 200, 150);
        System.out.println(dag);
        FruchtermanReingoldLayout layout = new FruchtermanReingoldLayout(dag);
        layout.doLayout();
    }

    public void testLayout2() {
        Dag dag = new Dag();
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        x1.setCenter(40, 5);
        x2.setCenter(50, 5);
        dag.addNode(x1);
        dag.addNode(x2);
        dag.addDirectedEdge(x1, x2);
        System.out.println(dag);
        FruchtermanReingoldLayout layout = new FruchtermanReingoldLayout(dag);
        layout.doLayout();
    }

    public static Test suite() {
        return new TestSuite(TestFruchtermanReingoldLayout.class);
    }
}

