/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestGraphUtils
extends TestCase {
    public TestGraphUtils(String name) {
        super(name);
    }

    public void testCreateRandomDag() {
        Dag dag = GraphUtils.randomDag(50, 0, 50, 4, 3, 3, false);
        System.out.println(dag);
    }

    public void testDirectedPaths() {
        Dag graph = GraphUtils.randomDag(6, 0, 10, 3, 3, 3, false);
        System.out.println("Graph = " + graph);
        for (int i = 0; i < graph.getNodes().size(); ++i) {
            for (int j = 0; j < graph.getNodes().size(); ++j) {
                Node node1 = graph.getNodes().get(i);
                Node node2 = graph.getNodes().get(j);
                System.out.println("Node1 = " + node1 + " Node2 = " + node2);
                List<List<Node>> directedPaths = GraphUtils.directedPathsFromTo(graph, node1, node2);
                for (int k = 0; k < directedPaths.size(); ++k) {
                    System.out.println("Path " + k + ": " + directedPaths.get(k));
                }
            }
        }
    }

    public void testTreks() {
        Dag graph = GraphUtils.randomDag(10, 0, 15, 3, 3, 3, false);
        System.out.println("Graph = " + graph);
        for (int i = 0; i < graph.getNodes().size(); ++i) {
            for (int j = 0; j < graph.getNodes().size(); ++j) {
                Node node1 = graph.getNodes().get(i);
                Node node2 = graph.getNodes().get(j);
                System.out.println("Node1 = " + node1 + " Node2 = " + node2);
                List<List<Node>> treks = GraphUtils.treks(graph, node1, node2);
                for (int k = 0; k < treks.size(); ++k) {
                    System.out.print("Trek " + k + ": ");
                    List<Node> trek = treks.get(k);
                    System.out.print(trek.get(0));
                    for (int m = 1; m < trek.size(); ++m) {
                        Node n0 = trek.get(m - 1);
                        Node n1 = trek.get(m);
                        Edge edge = graph.getEdge(n0, n1);
                        Endpoint endpoint0 = edge.getProximalEndpoint(n0);
                        Endpoint endpoint1 = edge.getProximalEndpoint(n1);
                        System.out.print(endpoint0 == Endpoint.ARROW ? "<" : "-");
                        System.out.print("-");
                        System.out.print(endpoint1 == Endpoint.ARROW ? ">" : "-");
                        System.out.print(n1);
                    }
                    System.out.println();
                }
            }
        }
    }

    public static Test suite() {
        return new TestSuite(TestGraphUtils.class);
    }
}

