/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.graph;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphNode;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public final class TestKamadaKawaiLayout
extends TestCase {
    public TestKamadaKawaiLayout(String name) {
        super(name);
    }

    public void testLayout() {
        Dag dag = new Dag();
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        GraphNode x3 = new GraphNode("X3");
        GraphNode x4 = new GraphNode("X4");
        GraphNode x5 = new GraphNode("X5");
        GraphNode x6 = new GraphNode("X6");
        GraphNode x7 = new GraphNode("X7");
        dag.addNode(x1);
        dag.addNode(x2);
        dag.addNode(x3);
        dag.addNode(x4);
        dag.addNode(x5);
        dag.addNode(x6);
        dag.addNode(x7);
        dag.addDirectedEdge(x1, x2);
        dag.addDirectedEdge(x2, x3);
        dag.addDirectedEdge(x4, x5);
        dag.addDirectedEdge(x5, x6);
        System.out.println(dag);
    }

    public void testSolve() {
        DenseDoubleMatrix2D a = new DenseDoubleMatrix2D(new double[][]{{1.0, 2.0}, {3.0, 4.0}});
        DenseDoubleMatrix2D b = new DenseDoubleMatrix2D(new double[][]{{1.0}, {1.0}});
        DoubleMatrix2D c = new Algebra().solve(a, b);
        System.out.println(a);
        System.out.println(b);
        System.out.println(c);
    }

    public static Test suite() {
        return new TestSuite(TestKamadaKawaiLayout.class);
    }
}

