/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.manip.experimental_setup;

import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.manip.experimental_setup.ExperimentalSetupVariable;
import edu.cmu.tetrad.manip.experimental_setup.VariableManipulation;
import edu.cmu.tetrad.manip.experimental_setup.VariablesStudied;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ExperimentalSetup
implements VariablesStudied,
Cloneable {
    private List<ExperimentalSetupVariable> variables;
    private String name;

    public ExperimentalSetup(String name, Graph graph) {
        this(name);
        ListIterator<Node> nodes = graph.getNodes().listIterator();
        while (nodes.hasNext()) {
            Node var = nodes.next();
            if (var.getNodeType() == NodeType.MEASURED) {
                this.variables.add(new ExperimentalSetupVariable(var.getName()));
                continue;
            }
            if (var.getNodeType() != NodeType.LATENT && var.getNodeType() != NodeType.ERROR) continue;
        }
    }

    public ExperimentalSetup(String name, String[] varNames) {
        this(name);
        for (int i = 0; i < varNames.length; ++i) {
            this.variables.add(new ExperimentalSetupVariable(varNames[i]));
        }
    }

    public ExperimentalSetup(ExperimentalSetup es) {
        this.name = es.getName();
        this.variables = new ArrayList<ExperimentalSetupVariable>();
        String[] varNames = es.getNamesOfStudiedVariables();
        for (int i = 0; i < varNames.length; ++i) {
            ExperimentalSetupVariable var = es.getVariable(varNames[i]);
            this.variables.add(new ExperimentalSetupVariable(var, 0.0, 1.0));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNumVariables() {
        return this.variables.size();
    }

    @Override
    public int getNumVariablesStudied() {
        int j = 0;
        Iterator<ExperimentalSetupVariable> vars = this.variables.iterator();
        while (vars.hasNext()) {
            if (!vars.next().isStudied()) continue;
            ++j;
        }
        return j;
    }

    public String[] getVariableNames() {
        String[] names = new String[this.variables.size()];
        int i = 0;
        Iterator<ExperimentalSetupVariable> vars = this.variables.iterator();
        while (vars.hasNext()) {
            names[i] = vars.next().getName();
            ++i;
        }
        return names;
    }

    @Override
    public String[] getNamesOfStudiedVariables() {
        String[] names = new String[this.getNumVariablesStudied()];
        int j = 0;
        for (int i = 0; i < this.variables.size(); ++i) {
            ExperimentalSetupVariable var = this.variables.get(i);
            if (!var.isStudied()) continue;
            names[j++] = var.getName();
        }
        return names;
    }

    public boolean isValidVariableName(String variableName) {
        for (ExperimentalSetupVariable var : this.variables) {
            if (!var.getName().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVariableStudied(String variableName) throws IllegalArgumentException {
        this.canManipulateVariable(variableName);
        return this.getVariable(variableName).isStudied();
    }

    public ExperimentalSetupVariable getVariable(String name) {
        for (ExperimentalSetupVariable var : this.variables) {
            if (!var.getName().equals(name)) continue;
            return var;
        }
        throw new IllegalArgumentException("variable " + name + " not in experimental setup");
    }

    private ExperimentalSetup(String name) {
        this.name = name;
        this.variables = new ArrayList<ExperimentalSetupVariable>();
    }

    private void canManipulateVariable(String variableName) throws IllegalArgumentException {
        ExperimentalSetupVariable var = this.getVariable(variableName);
        if (var.getManipulation() == VariableManipulation.LATENT) {
            throw new IllegalArgumentException("Cannot set manipulation for Latent variable " + variableName);
        }
        if (var.getManipulation() == VariableManipulation.ERROR) {
            throw new IllegalArgumentException("Cannot set manipulation for Error variable " + variableName);
        }
    }
}

